/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesLeaderboards;
import serverutils.data.Leaderboard;
import serverutils.lib.command.CmdBase;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.Universe;
import serverutils.lib.util.StringUtils;

public class CmdLeaderboard
extends CmdBase {
    public CmdLeaderboard() {
        super("leaderboards", CmdBase.Level.ALL);
    }

    @Override
    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CmdLeaderboard.matchFromIterable(args, ServerUtilitiesLeaderboards.LEADERBOARDS.keySet());
        }
        return super.func_71516_a(sender, args);
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            ChatComponentText component = new ChatComponentText("");
            component.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, StringUtils.color(ServerUtilities.lang(sender, "click_here", new Object[0]), EnumChatFormatting.GOLD)));
            boolean first = true;
            for (Leaderboard leaderboard : ServerUtilitiesLeaderboards.LEADERBOARDS.values()) {
                if (first) {
                    first = false;
                } else {
                    component.func_150258_a(", ");
                }
                IChatComponent component1 = leaderboard.getTitle().func_150259_f();
                component1.func_150256_b().func_150238_a(EnumChatFormatting.GOLD);
                component1.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/leaderboards " + leaderboard.id));
                component.func_150257_a(component1);
            }
            sender.func_145747_a((IChatComponent)component);
        } else if (ServerUtilitiesLeaderboards.LEADERBOARDS.get(new ResourceLocation(args[0])) != null) {
            Leaderboard leaderboard = ServerUtilitiesLeaderboards.LEADERBOARDS.get(new ResourceLocation(args[0]));
            sender.func_145747_a(leaderboard.getTitle().func_150259_f().func_150258_a(":"));
            ForgePlayer p0 = sender instanceof EntityPlayerMP ? Universe.get().getPlayer(sender) : null;
            ArrayList<ForgePlayer> players = new ArrayList<ForgePlayer>(Universe.get().getPlayers());
            players.sort(leaderboard.getComparator());
            for (int i = 0; i < players.size(); ++i) {
                ForgePlayer p = (ForgePlayer)players.get(i);
                IChatComponent component = new ChatComponentText("#" + StringUtils.add0s(i + 1, players.size()) + " ").func_150257_a(p.getDisplayName()).func_150258_a(": ");
                component.func_150257_a(leaderboard.createValue(p));
                if (p == p0) {
                    component.func_150256_b().func_150238_a(EnumChatFormatting.DARK_GREEN);
                } else if (!leaderboard.hasValidValue(p)) {
                    component.func_150256_b().func_150238_a(EnumChatFormatting.DARK_GRAY);
                } else if (i < 3) {
                    component.func_150256_b().func_150238_a(EnumChatFormatting.GOLD);
                }
                sender.func_145747_a(component);
            }
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText("Invalid ID!"));
        }
    }
}

