/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.config;

import com.google.gson.JsonElement;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.ConfigValueInstance;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.util.JsonUtils;
import serverutils.lib.util.NBTUtils;

public class ConfigNBT
extends ConfigValue {
    public static final String ID = "nbt";
    private NBTTagCompound value;

    public ConfigNBT(@Nullable NBTTagCompound nbt) {
        this.value = nbt;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getString() {
        return this.value == null ? "null" : this.value.toString();
    }

    @Nullable
    public NBTTagCompound getNBT() {
        return this.value;
    }

    public void setNBT(@Nullable NBTTagCompound nbt) {
        this.value = nbt;
    }

    @Override
    public boolean getBoolean() {
        this.value = this.getNBT();
        return this.value != null && !this.value.func_82582_d();
    }

    @Override
    public int getInt() {
        this.value = this.getNBT();
        return this.value == null ? 0 : this.value.hashCode();
    }

    @Override
    public ConfigNBT copy() {
        this.value = this.getNBT();
        return new ConfigNBT(this.value == null ? null : (NBTTagCompound)this.value.func_74737_b());
    }

    @Override
    public IChatComponent getStringForGUI() {
        return new ChatComponentText(this.getNBT() == null ? "null" : "{...}");
    }

    @Override
    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        if (string.equals("null")) {
            if (!simulate) {
                this.setNBT(null);
            }
            return true;
        }
        try {
            this.value = (NBTTagCompound)JsonToNBT.func_150315_a((String)string);
            if (!simulate) {
                this.setNBT(this.value);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void addInfo(ConfigValueInstance inst, List<String> list) {
        list.add(EnumChatFormatting.AQUA + "Value: " + EnumChatFormatting.RESET + NBTUtils.getColoredNBTString((NBTBase)this.getNBT()));
        if (inst.getCanEdit() && inst.getDefaultValue() instanceof ConfigNBT) {
            list.add(EnumChatFormatting.AQUA + "Default: " + EnumChatFormatting.RESET + NBTUtils.getColoredNBTString((NBTBase)((ConfigNBT)inst.getDefaultValue()).getNBT()));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        this.value = this.getNBT();
        if (this.value != null) {
            nbt.func_74782_a(key, (NBTBase)this.value);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        this.value = nbt.func_74764_b(key) ? nbt.func_74775_l(key) : null;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeNBT(this.getNBT());
    }

    @Override
    public void readData(DataIn data) {
        this.setNBT(data.readNBT());
    }

    @Override
    public boolean isEmpty() {
        this.value = this.getNBT();
        return this.value == null || this.value.func_82582_d();
    }

    @Override
    public void setValueFromOtherValue(ConfigValue value) {
        if (value instanceof ConfigNBT) {
            NBTTagCompound nbt = ((ConfigNBT)value).getNBT();
            this.setNBT(nbt == null ? null : (NBTTagCompound)nbt.func_74737_b());
        } else {
            super.setValueFromOtherValue(value);
        }
    }

    @Override
    public void setValueFromJson(JsonElement json) {
        if (json.isJsonObject()) {
            this.setNBT((NBTTagCompound)JsonUtils.toNBT(json));
        }
    }
}

