/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.util.compression;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.Enumeration;
import javax.annotation.Nullable;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import serverutils.ServerUtilitiesConfig;
import serverutils.lib.util.FileUtils;
import serverutils.lib.util.compression.ICompress;

public class CommonsCompressor
implements ICompress {
    private ArchiveOutputStream output;

    @Override
    public void createOutputStream(File file) throws IOException {
        ZipArchiveOutputStream zaos = new ZipArchiveOutputStream(file);
        if (ServerUtilitiesConfig.backups.compression_level == 0) {
            zaos.setMethod(0);
        } else {
            zaos.setLevel(ServerUtilitiesConfig.backups.compression_level);
        }
        File worldDir = DimensionManager.getCurrentSaveRootDirectory();
        if (worldDir != null) {
            zaos.setComment(worldDir.getName());
        }
        this.output = zaos;
    }

    @Override
    public void addFileToArchive(File file, String name) throws IOException {
        ArchiveEntry entry = this.output.createArchiveEntry(file, name);
        this.output.putArchiveEntry(entry);
        try (FileInputStream fis = new FileInputStream(file);){
            IOUtils.copy((InputStream)fis, (OutputStream)this.output);
        }
        this.output.closeArchiveEntry();
    }

    private static boolean shouldExtract(File file, boolean includeGlobal) {
        if (includeGlobal) {
            return true;
        }
        for (String pattern : ServerUtilitiesConfig.backups.additional_backup_files) {
            PathMatcher matcher;
            if (pattern.contains("$WORLDNAME") || !(matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern)).matches(file.toPath())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isOldBackup(File archive) throws IOException {
        try (ZipFile zip = new ZipFile(archive);){
            boolean isOldBackup = true;
            Enumeration entries = zip.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                if (!entry.getName().replace('\\', '/').startsWith("saves/")) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    @Override
    public void extractArchive(File archive, boolean includeGlobal, boolean isOldBackup) throws IOException {
        try (ZipFile zip = new ZipFile(archive);){
            String prefix;
            Enumeration entries = zip.getEntries();
            String string = prefix = isOldBackup ? "saves/" : "";
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                File file = new File(prefix + entry.getName());
                if (!CommonsCompressor.shouldExtract(file, includeGlobal)) continue;
                file = FileUtils.newFile(file);
                InputStream in = zip.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(file);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                in.close();
                ((OutputStream)out).close();
            }
        }
    }

    @Override
    @Nullable
    public String getWorldName(File file) throws IOException {
        if (file.isDirectory() || !file.getName().endsWith(".zip")) {
            return null;
        }
        try (java.util.zip.ZipFile zipFile = new java.util.zip.ZipFile(file);){
            String string = zipFile.getComment();
            return string;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.output != null) {
            this.output.close();
        }
    }
}

