/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import it.unimi.dsi.fastutil.ints.IntComparators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilitiesPermissions;
import serverutils.client.gui.ranks.GuiRanks;
import serverutils.client.gui.ranks.RankInst;
import serverutils.data.NodeEntry;
import serverutils.lib.command.CommandUtils;
import serverutils.lib.config.ConfigBoolean;
import serverutils.lib.config.ConfigGroup;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.RankConfigAPI;
import serverutils.lib.config.RankConfigValueInfo;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToClient;
import serverutils.lib.net.NetworkWrapper;
import serverutils.lib.util.ServerUtils;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.permission.DefaultPermissionHandler;
import serverutils.lib.util.permission.DefaultPermissionLevel;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.net.ServerUtilitiesNetHandler;
import serverutils.ranks.ICommandWithPermission;
import serverutils.ranks.PlayerRank;
import serverutils.ranks.Rank;
import serverutils.ranks.Ranks;

public class MessageRanks
extends MessageToClient {
    private Collection<RankInst> ranks;
    private Map<String, RankInst> playerRanks;
    private static ConfigGroup allPermissions;
    private static ConfigGroup commandPermissions;

    public MessageRanks() {
    }

    public MessageRanks(Ranks r, ForgePlayer p) {
        this.ranks = new ArrayList<RankInst>();
        for (Rank rank : r.ranks.values()) {
            ConfigGroup group = ConfigGroup.newGroup("");
            ChatComponentText name = new ChatComponentText(EnumChatFormatting.BOLD + StringUtils.firstUppercase(rank.getId()));
            group.setDisplayName((IChatComponent)name);
            RankInst inst = new RankInst(rank.getId());
            for (Rank.Entry entry : rank.permissions.values()) {
                String permissionNode = entry.node;
                ConfigValue val = rank.getPermissionValue(permissionNode);
                ConfigValue defaultValue = RankConfigAPI.getConfigValue(permissionNode, false);
                group.add(permissionNode, val, defaultValue, 30).setDisplayName((IChatComponent)new ChatComponentTranslation(permissionNode, new Object[0]));
            }
            inst.group = group;
            ArrayList<String> parents = new ArrayList<String>();
            for (Rank rs : rank.getParents()) {
                parents.add(rs.getId());
            }
            inst.parents = parents;
            this.ranks.add(inst);
        }
        this.playerRanks = new HashMap<String, RankInst>();
        for (ForgePlayer forgePlayer : r.universe.getPlayers()) {
            RankInst inst = new RankInst(forgePlayer.getProfile().getId().toString());
            boolean isOp = ServerUtils.isOP(null, forgePlayer.getProfile());
            inst.group = ConfigGroup.newGroup(forgePlayer.getName());
            inst.group.add("is_op", new ConfigBoolean(isOp), null).setExcluded(true);
            inst.player = forgePlayer.getName();
            PlayerRank pRank = r.getPlayerRank(forgePlayer.getProfile());
            ArrayList<Rank> sortedParents = new ArrayList<Rank>(pRank.getActualParents());
            sortedParents.sort((r1, r2) -> IntComparators.OPPOSITE_COMPARATOR.compare(r1.getPriority(), r2.getPriority()));
            for (Rank rank : sortedParents) {
                inst.parents.add(rank.getId());
            }
            this.playerRanks.put(forgePlayer.getName(), inst);
        }
        if (allPermissions == null) {
            allPermissions = ConfigGroup.newGroup("");
            for (RankConfigValueInfo rankConfigValueInfo : RankConfigAPI.getHandler().getRegisteredConfigs()) {
                allPermissions.add(rankConfigValueInfo.node, rankConfigValueInfo.defaultValue, rankConfigValueInfo.defaultValue, 30).setDisplayName((IChatComponent)new ChatComponentTranslation(rankConfigValueInfo.node, new Object[0]));
            }
            Collection<NodeEntry> prefixesToSkip = ServerUtilitiesPermissions.getPrefixesExcluding("serverutilities.leaderboard.");
            for (String node : PermissionAPI.getPermissionHandler().getRegisteredNodes()) {
                DefaultPermissionLevel level = DefaultPermissionHandler.INSTANCE.getDefaultPermissionLevel(node);
                String desc = PermissionAPI.getPermissionHandler().getNodeDescription(node);
                boolean printNode = true;
                if (node.startsWith("command")) continue;
                for (NodeEntry cprefix : prefixesToSkip) {
                    if (!node.startsWith(cprefix.getNode())) continue;
                    if (cprefix.level == null || level != cprefix.level || !desc.isEmpty()) break;
                    printNode = false;
                    break;
                }
                if (!printNode) continue;
                ConfigBoolean configBoolean = new ConfigBoolean(level == DefaultPermissionLevel.ALL);
                allPermissions.add(node, configBoolean, configBoolean, 30).setDisplayName((IChatComponent)new ChatComponentTranslation(node, new Object[0]));
            }
        }
        if (commandPermissions == null) {
            commandPermissions = ConfigGroup.newGroup("");
            for (ICommandWithPermission iCommandWithPermission : CommandUtils.getPermissionCommands()) {
                String node;
                node = iCommandWithPermission.serverutilities$getPermissionNode();
                DefaultPermissionLevel level = DefaultPermissionHandler.INSTANCE.getDefaultPermissionLevel(node);
                ChatComponentText name = new ChatComponentText(EnumChatFormatting.BLUE + "[" + iCommandWithPermission.serverutilities$getModName() + "]\n");
                ConfigBoolean val = new ConfigBoolean(level == DefaultPermissionLevel.ALL);
                commandPermissions.add(node, val, val, 30).setDisplayName((IChatComponent)new ChatComponentTranslation(node, new Object[0])).setInfo(name.func_150257_a(CommandUtils.getTranslatedUsage((ICommand)iCommandWithPermission, (ICommandSender)p.getPlayer())));
            }
        }
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.FILES;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeCollection(this.ranks, RankInst.SERIALIZER);
        data.writeMap(this.playerRanks, DataOut.STRING, RankInst.SERIALIZER);
        ConfigGroup.SERIALIZER.write(data, allPermissions);
        ConfigGroup.SERIALIZER.write(data, commandPermissions);
    }

    @Override
    public void readData(DataIn data) {
        this.ranks = data.readCollection(RankInst.DESERIALIZER);
        this.playerRanks = data.readMap(DataIn.STRING, RankInst.DESERIALIZER);
        allPermissions = ConfigGroup.DESERIALIZER.read(data);
        commandPermissions = ConfigGroup.DESERIALIZER.read(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        new GuiRanks(this.ranks, this.playerRanks, allPermissions, commandPermissions).openGui();
    }
}

