/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.gregtech.gregtech5;

import gregtech.api.interfaces.IConfigurationCircuitSupport;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.common.items.ItemIntegratedCircuit;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.integration.ManagedEnvironmentOCTile;

public class DriverGregTechCircuitConfigurableMachine
extends DriverSidedTileEntity {
    private static final int NO_CONFIG = -1;

    public Class<?> getTileEntityClass() {
        return BaseMetaTileEntity.class;
    }

    public boolean worksWith(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof BaseMetaTileEntity) {
            IMetaTileEntity mte = ((BaseMetaTileEntity)tileEntity).getMetaTileEntity();
            return mte instanceof IConfigurationCircuitSupport;
        }
        return false;
    }

    public ManagedEnvironment createEnvironment(World world, int x, int y, int z, ForgeDirection side) {
        IMetaTileEntity mte;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof BaseMetaTileEntity && (mte = ((BaseMetaTileEntity)tileEntity).getMetaTileEntity()) instanceof IConfigurationCircuitSupport) {
            return new ManagedEnvironmentGregTechCircuitConfig(mte, "gt_machine");
        }
        return null;
    }

    public static class ManagedEnvironmentGregTechCircuitConfig
    extends ManagedEnvironmentOCTile<IMetaTileEntity> {
        public static final int MAX_CIRCUIT_NUMBER = 24;

        public ManagedEnvironmentGregTechCircuitConfig(IMetaTileEntity tile, String name) {
            super(tile, name);
        }

        @Override
        public int priority() {
            return 0;
        }

        private int getCircuitSlot() {
            if (this.tile instanceof IConfigurationCircuitSupport) {
                return ((IConfigurationCircuitSupport)this.tile).getCircuitSlot();
            }
            return -1;
        }

        @Callback(doc="function():number; Gets the circuit configuration. Returns -1 if no circuit or not applicable.")
        public Object[] getCircuitConfiguration(Context context, Arguments args) {
            if (!(this.tile instanceof IConfigurationCircuitSupport)) {
                return new Object[]{null, "Machine does not support circuit configuration."};
            }
            int circuitSlot = this.getCircuitSlot();
            if (circuitSlot < 0 || circuitSlot >= ((IMetaTileEntity)this.tile).func_70302_i_()) {
                return new Object[]{null, "Invalid circuit slot index."};
            }
            ItemStack stack = ((IMetaTileEntity)this.tile).func_70301_a(circuitSlot);
            if (stack != null && stack.func_77973_b() instanceof ItemIntegratedCircuit) {
                return new Object[]{stack.func_77960_j()};
            }
            return new Object[]{-1};
        }

        @Callback(doc="function(config:number):boolean or (nil, string); Sets the circuit configuration. Use -1 to remove circuit. Returns true on success.")
        public Object[] setCircuitConfiguration(Context context, Arguments args) {
            if (!(this.tile instanceof IConfigurationCircuitSupport)) {
                return new Object[]{null, "Machine does not support circuit configuration."};
            }
            int circuitSlot = this.getCircuitSlot();
            if (circuitSlot < 0 || circuitSlot >= ((IMetaTileEntity)this.tile).func_70302_i_()) {
                return new Object[]{null, "Invalid circuit slot index."};
            }
            int config = args.checkInteger(0);
            if (config == -1) {
                ((IMetaTileEntity)this.tile).func_70299_a(circuitSlot, null);
                return new Object[]{true};
            }
            if (config >= 1 && config <= 24) {
                ItemStack circuitStack = GTUtility.getIntegratedCircuit((int)config);
                ((IMetaTileEntity)this.tile).func_70299_a(circuitSlot, circuitStack);
                return new Object[]{true};
            }
            return new Object[]{null, "Invalid circuit configuration value: " + config + ". Must be between 1 and " + 24 + ", or " + -1 + "."};
        }
    }
}

