/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.parts.base;

import appeng.api.implementations.parts.IPartStorageMonitor;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.parts.IBoxProvider;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.DimensionalCoord;
import appeng.client.ClientHelper;
import appeng.client.texture.CableBusTextures;
import appeng.core.AELog;
import appeng.core.localization.PlayerMessages;
import appeng.hooks.TickHandler;
import appeng.me.GridAccessException;
import appeng.parts.reporting.AbstractPartDisplay;
import appeng.util.IWideReadableNumberConverter;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import appeng.util.item.AEFluidStack;
import com.glodblock.github.client.textures.FCPartsTexture;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.util.Util;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public abstract class FCPartMonitor
extends AbstractPartDisplay
implements IPartStorageMonitor,
IStackWatcherHost {
    private static final IWideReadableNumberConverter NUMBER_CONVERTER = ReadableNumberConverter.INSTANCE;
    private IAEFluidStack configuredFluid;
    private String lastHumanReadableText;
    private boolean isLocked;
    private IStackWatcher myWatcher;
    @SideOnly(value=Side.CLIENT)
    private boolean updateList;
    @SideOnly(value=Side.CLIENT)
    private Integer dspList;

    public FCPartMonitor(ItemStack is) {
        super(is);
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isLocked = data.func_74767_n("isLocked");
        NBTTagCompound myItem = data.func_74775_l("configuredItem");
        this.configuredFluid = Util.loadFluidStackFromNBT(myItem);
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("isLocked", this.isLocked);
        NBTTagCompound myItem = new NBTTagCompound();
        if (this.configuredFluid != null) {
            this.configuredFluid.writeToNBT(myItem);
        }
        data.func_74782_a("configuredItem", (NBTBase)myItem);
    }

    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.isLocked);
        data.writeBoolean(this.configuredFluid != null);
        if (this.configuredFluid != null) {
            this.configuredFluid.writeToPacket(data);
        }
    }

    public boolean readFromStream(ByteBuf data) throws IOException {
        boolean needRedraw = super.readFromStream(data);
        boolean isLocked = data.readBoolean();
        needRedraw |= this.isLocked != isLocked;
        this.isLocked = isLocked;
        boolean val = data.readBoolean();
        if (val) {
            needRedraw |= this.configuredFluid == null;
            this.configuredFluid = AEFluidStack.loadFluidStackFromPacket((ByteBuf)data);
        } else {
            needRedraw |= this.configuredFluid != null;
            this.configuredFluid = null;
        }
        this.updateList = true;
        return needRedraw;
    }

    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions((DimensionalCoord)this.getLocation(), (EntityPlayer)player)) {
            return false;
        }
        TileEntity te = this.getTile();
        ItemStack eq = player.func_71045_bC();
        if (Platform.isWrench((EntityPlayer)player, (ItemStack)eq, (int)te.field_145851_c, (int)te.field_145848_d, (int)te.field_145849_e)) {
            this.isLocked = !this.isLocked;
            player.func_145747_a((this.isLocked ? PlayerMessages.isNowLocked : PlayerMessages.isNowUnlocked).toChat());
            this.getHost().markForUpdate();
        } else if (!this.isLocked) {
            this.configuredFluid = AEFluidStack.create((Object)Util.FluidUtil.getFluidFromContainer(eq));
            this.configureWatchers();
            this.getHost().markForUpdate();
        } else {
            this.extractItem(player);
        }
        return true;
    }

    private void configureWatchers() {
        if (this.myWatcher != null) {
            this.myWatcher.clear();
        }
        try {
            if (this.configuredFluid != null) {
                if (this.myWatcher != null) {
                    this.myWatcher.add((Object)this.configuredFluid);
                }
                this.updateReportingValue((IMEMonitor<IAEFluidStack>)this.getProxy().getStorage().getFluidInventory());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    protected void extractItem(EntityPlayer player) {
    }

    private void updateReportingValue(IMEMonitor<IAEFluidStack> fluidInventory) {
        if (this.configuredFluid != null) {
            IAEFluidStack result = (IAEFluidStack)fluidInventory.getStorageList().findPrecise((IAEStack)this.configuredFluid);
            if (result == null) {
                this.configuredFluid.setStackSize(0L);
            } else {
                this.configuredFluid.setStackSize(result.getStackSize());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void finalize() throws Throwable {
        super.finalize();
        if (this.dspList != null) {
            TickHandler.INSTANCE.scheduleCallListDelete(this.dspList);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(double x, double y, double z, IPartRenderHelper rh, RenderBlocks renderer) {
        if (this.dspList == null) {
            this.dspList = GLAllocation.func_74526_a((int)1);
        }
        Tessellator tess = Tessellator.field_78398_a;
        if ((this.getClientFlags() & 0x14) != 20) {
            return;
        }
        IAEFluidStack ais = (IAEFluidStack)this.getDisplayed();
        if (ais != null) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            if (this.updateList) {
                this.updateList = false;
                GL11.glNewList((int)this.dspList, (int)4865);
                this.tesrRenderScreen(tess, ais);
                GL11.glEndList();
            } else {
                GL11.glCallList((int)this.dspList);
            }
            GL11.glPopMatrix();
        }
    }

    public boolean requireDynamicRender() {
        return true;
    }

    public IAEStack<?> getDisplayed() {
        return this.configuredFluid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tesrRenderScreen(Tessellator tess, IAEFluidStack ais) {
        ForgeDirection d = this.getSide();
        GL11.glTranslated((double)((double)d.offsetX * 0.77), (double)((double)d.offsetY * 0.77), (double)((double)d.offsetZ * 0.77));
        switch (d) {
            case UP: {
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)((float)this.getSpin() * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case DOWN: {
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)((float)this.getSpin() * -90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                break;
            }
            case SOUTH: {
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
        }
        ItemStack sis = ItemFluidPacket.newDisplayStack(ais.getFluidStack());
        try {
            int br = 0x1000100;
            int var11 = 256;
            int var12 = 256;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)204.8f, (float)204.8f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)32826);
            tess.func_78386_a(1.0f, 1.0f, 1.0f);
            ClientHelper.proxy.doRenderItem(sis, this.getTile().func_145831_w());
        }
        catch (Exception e) {
            AELog.debug((Throwable)e);
        }
        finally {
            GL11.glEnable((int)2896);
            GL11.glEnable((int)32826);
        }
        if (sis != null) {
            GL11.glTranslatef((float)0.0f, (float)0.14f, (float)-0.24f);
            GL11.glScalef((float)0.016129032f, (float)0.016129032f, (float)0.016129032f);
            long stackSize = ais.getStackSize();
            String renderedStackSize = NUMBER_CONVERTER.toWideReadableForm(stackSize);
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            int width = fr.func_78256_a(renderedStackSize);
            GL11.glTranslatef((float)(-0.5f * (float)width), (float)0.0f, (float)-1.0f);
            fr.func_78276_b(renderedStackSize, 0, 0, 0);
        }
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void updateWatcher(IStackWatcher newWatcher) {
        this.myWatcher = newWatcher;
        this.configureWatchers();
    }

    public void onStackChange(IItemList o, IAEStack fullStack, IAEStack diffStack, BaseActionSource src, StorageChannel chan) {
        if (this.configuredFluid != null) {
            if (fullStack == null) {
                this.configuredFluid.setStackSize(0L);
            } else {
                this.configuredFluid.setStackSize(fullStack.getStackSize());
            }
            long stackSize = this.configuredFluid.getStackSize();
            String humanReadableText = NUMBER_CONVERTER.toWideReadableForm(stackSize);
            if (!humanReadableText.equals(this.lastHumanReadableText)) {
                this.lastHumanReadableText = humanReadableText;
                this.getHost().markForUpdate();
            }
        }
    }

    public boolean showNetworkInfo(MovingObjectPosition where) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        IIcon sideTexture = CableBusTextures.PartMonitorSides.getIcon();
        IIcon backTexture = CableBusTextures.PartMonitorBack.getIcon();
        rh.setTexture(sideTexture, sideTexture, backTexture, FCPartsTexture.PartTerminalBroad.getIcon(), sideTexture, sideTexture);
        rh.renderInventoryBox(renderer);
        rh.setInvColor(this.getColor().whiteVariant);
        rh.renderInventoryFace(this.getFrontBright().getIcon(), ForgeDirection.SOUTH, renderer);
        rh.setInvColor(this.getColor().mediumVariant);
        rh.renderInventoryFace(this.getFrontDark().getIcon(), ForgeDirection.SOUTH, renderer);
        rh.setInvColor(this.getColor().blackVariant);
        rh.renderInventoryFace(this.getFrontColored().getIcon(), ForgeDirection.SOUTH, renderer);
        rh.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        rh.renderInventoryBox(renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        int l;
        boolean hasPower;
        this.setRenderCache(rh.useSimplifiedRendering(x, y, z, (IBoxProvider)this, this.getRenderCache()));
        IIcon sideTexture = CableBusTextures.PartMonitorSides.getIcon();
        IIcon backTexture = CableBusTextures.PartMonitorBack.getIcon();
        rh.setTexture(sideTexture, sideTexture, backTexture, FCPartsTexture.PartTerminalBroad.getIcon(), sideTexture, sideTexture);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        Tessellator tess = Tessellator.field_78398_a;
        if (this.getLightLevel() > 0) {
            int l2 = 13;
            tess.func_78380_c(0xD000D0);
        }
        byte by = this.getSpin();
        renderer.field_147873_r = by;
        renderer.field_147867_u = by;
        renderer.field_147871_s = by;
        renderer.field_147869_t = by;
        renderer.field_147875_q = by;
        renderer.field_147865_v = by;
        tess.func_78378_d(this.getColor().whiteVariant);
        rh.renderFace(x, y, z, this.getFrontBright().getIcon(), ForgeDirection.SOUTH, renderer);
        tess.func_78378_d(this.getColor().mediumVariant);
        rh.renderFace(x, y, z, this.getFrontDark().getIcon(), ForgeDirection.SOUTH, renderer);
        tess.func_78378_d(this.getColor().blackVariant);
        rh.renderFace(x, y, z, this.getFrontColored().getIcon(), ForgeDirection.SOUTH, renderer);
        renderer.field_147873_r = 0;
        renderer.field_147867_u = 0;
        renderer.field_147871_s = 0;
        renderer.field_147869_t = 0;
        renderer.field_147875_q = 0;
        renderer.field_147865_v = 0;
        IIcon sideStatusTexture = CableBusTextures.PartMonitorSidesStatus.getIcon();
        rh.setTexture(sideStatusTexture, sideStatusTexture, backTexture, FCPartsTexture.PartTerminalBroad.getIcon(), sideStatusTexture, sideStatusTexture);
        rh.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        boolean hasChan = (this.getClientFlags() & 0x14) == 20;
        boolean bl = hasPower = (this.getClientFlags() & 4) == 4;
        if (hasChan) {
            l = 14;
            tess.func_78380_c(0xE000E0);
            tess.func_78378_d(this.getColor().blackVariant);
        } else if (hasPower) {
            l = 9;
            tess.func_78380_c(0x900090);
            tess.func_78378_d(this.getColor().whiteVariant);
        } else {
            tess.func_78380_c(0);
            tess.func_78378_d(0);
        }
        IIcon sideStatusLightTexture = CableBusTextures.PartMonitorSidesStatusLights.getIcon();
        rh.renderFace(x, y, z, sideStatusLightTexture, ForgeDirection.EAST, renderer);
        rh.renderFace(x, y, z, sideStatusLightTexture, ForgeDirection.WEST, renderer);
        rh.renderFace(x, y, z, sideStatusLightTexture, ForgeDirection.UP, renderer);
        rh.renderFace(x, y, z, sideStatusLightTexture, ForgeDirection.DOWN, renderer);
    }

    public IAEFluidStack getAEStoreFluidStack() {
        return this.configuredFluid;
    }
}

