/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.StorageFilter;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AELog;
import appeng.util.item.AEFluidStack;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class MEMonitorIFluidHandler
implements IMEMonitor<IAEFluidStack> {
    private static boolean WrongFluidRemovedWarnIssued = false;
    private final IFluidHandler handler;
    private final ForgeDirection side;
    private IItemList<IAEFluidStack> cache = AEApi.instance().storage().createFluidList();
    private final HashMap<IMEMonitorHandlerReceiver<IAEFluidStack>, Object> listeners = new HashMap();
    private BaseActionSource mySource;
    private StorageFilter mode = StorageFilter.EXTRACTABLE_ONLY;

    public MEMonitorIFluidHandler(IFluidHandler handler, ForgeDirection side) {
        this.handler = handler;
        this.side = side;
    }

    public MEMonitorIFluidHandler(IFluidHandler handler) {
        this.handler = handler;
        this.side = ForgeDirection.UNKNOWN;
    }

    public void addListener(IMEMonitorHandlerReceiver<IAEFluidStack> l, Object verificationToken) {
        this.listeners.put(l, verificationToken);
    }

    public void removeListener(IMEMonitorHandlerReceiver<IAEFluidStack> l) {
        this.listeners.remove(l);
    }

    public IAEFluidStack injectItems(IAEFluidStack input, Actionable type, BaseActionSource src) {
        if (!this.handler.canFill(this.side, input.getFluid())) {
            return input;
        }
        int filled = this.handler.fill(this.side, input.getFluidStack(), type == Actionable.MODULATE);
        if (type == Actionable.MODULATE) {
            this.onTick();
        }
        if ((long)filled == input.getStackSize()) {
            return null;
        }
        IAEFluidStack o = input.copy();
        o.setStackSize(input.getStackSize() - (long)filled);
        return o;
    }

    public IAEFluidStack extractItems(IAEFluidStack request, Actionable type, BaseActionSource src) {
        if (!this.handler.canDrain(this.side, request.getFluid())) {
            return null;
        }
        FluidStack removed = this.handler.drain(this.side, request.getFluidStack(), type == Actionable.MODULATE);
        if (removed != null && removed.amount != 0) {
            IAEFluidStack cachedStack;
            if (!WrongFluidRemovedWarnIssued && !removed.isFluidEqual(request.getFluidStack())) {
                WrongFluidRemovedWarnIssued = true;
                String issuesUrl = "https://github.com/GTNewHorizons/GT-New-Horizons-Modpack/issues/new";
                String msg = String.format("[AE2FC] MEMonitorIFluidHandler.extractItems got the wrong fluids while extracting from %s. expected %s got %s. Please report this message if seen: ", this.handler.getClass().getSimpleName(), request.getFluidStack().getUnlocalizedName(), removed.getUnlocalizedName());
                AELog.warn((String)(msg + issuesUrl), (Object[])new Object[0]);
                ChatComponentText chatTxt = new ChatComponentText(msg);
                chatTxt.func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED).func_150227_a(Boolean.valueOf(true)));
                ChatComponentText chatUrl = new ChatComponentText(issuesUrl);
                chatUrl.func_150255_a(new ChatStyle().func_150228_d(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, issuesUrl)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText("Click to open link"))));
                ChatComponentText chat = new ChatComponentText("");
                chat.func_150257_a((IChatComponent)chatTxt);
                chat.func_150257_a((IChatComponent)chatUrl);
                MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)chat);
            }
            IAEFluidStack o = request.copy();
            o.setStackSize((long)removed.amount);
            if (type == Actionable.MODULATE && (cachedStack = (IAEFluidStack)this.cache.findPrecise((IAEStack)request)) != null) {
                cachedStack.decStackSize(o.getStackSize());
                this.postDifference(Collections.singletonList((IAEFluidStack)o.copy().setStackSize(-o.getStackSize())));
            }
            return o;
        }
        return null;
    }

    public StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }

    public TickRateModulation onTick() {
        FluidTankInfo[] tankProperties = this.handler.getTankInfo(this.side);
        IItemList currentlyOnStorage = AEApi.instance().storage().createFluidList();
        if (tankProperties != null) {
            for (FluidTankInfo tankProperty : tankProperties) {
                if (this.mode == StorageFilter.EXTRACTABLE_ONLY && this.handler.drain(this.side, 1, false) == null) continue;
                currentlyOnStorage.add((IAEStack)AEFluidStack.create((Object)tankProperty.fluid));
            }
        }
        IItemList changes = AEApi.instance().storage().createFluidList();
        Iterator iter = this.cache.iterator();
        while (iter.hasNext()) {
            IAEFluidStack copy = ((IAEFluidStack)iter.next()).copy();
            copy.setStackSize(-copy.getStackSize());
            changes.add((IAEStack)copy);
        }
        for (IAEFluidStack is : currentlyOnStorage) {
            changes.add((IAEStack)is);
        }
        this.cache = currentlyOnStorage;
        iter = changes.iterator();
        while (iter.hasNext()) {
            if (((IAEFluidStack)iter.next()).getStackSize() != 0L) continue;
            iter.remove();
        }
        if (!changes.isEmpty()) {
            this.postDifference((Iterable<IAEFluidStack>)changes);
            return TickRateModulation.URGENT;
        }
        return TickRateModulation.SLOWER;
    }

    private void postDifference(Iterable<IAEFluidStack> a) {
        if (a != null) {
            Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEFluidStack>, Object>> i = this.listeners.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<IMEMonitorHandlerReceiver<IAEFluidStack>, Object> l = i.next();
                IMEMonitorHandlerReceiver<IAEFluidStack> key = l.getKey();
                if (key.isValid(l.getValue())) {
                    key.postChange((IBaseMonitor)this, a, this.getActionSource());
                    continue;
                }
                i.remove();
            }
        }
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    public boolean isPrioritized(IAEFluidStack input) {
        return false;
    }

    public boolean canAccept(IAEFluidStack input) {
        return true;
    }

    public int getPriority() {
        return 0;
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int i) {
        return true;
    }

    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out, int iteration) {
        for (IAEFluidStack fs : this.cache) {
            out.addStorage((IAEStack)fs);
        }
        return out;
    }

    public IAEFluidStack getAvailableItem(@Nonnull IAEFluidStack request, int iteration) {
        return (IAEFluidStack)this.cache.findPrecise((IAEStack)request);
    }

    public IItemList<IAEFluidStack> getStorageList() {
        return this.cache;
    }

    public void setMode(StorageFilter mode) {
        this.mode = mode;
    }

    private BaseActionSource getActionSource() {
        return this.mySource;
    }

    public void setActionSource(BaseActionSource mySource) {
        this.mySource = mySource;
    }
}

