/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.nei;

import appeng.api.AEApi;
import appeng.api.config.TerminalFontSize;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.client.render.StackSizeRenderer;
import appeng.core.localization.GuiText;
import appeng.util.IterationCounter;
import appeng.util.Platform;
import appeng.util.item.FluidList;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.IUsageHandler;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.storage.FluidCellInventoryHandler;
import com.glodblock.github.util.ModAndClassUtil;
import com.mitchej123.hodgepodge.textures.IPatchedTextureAtlasSprite;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class NEICellViewHandler
implements IUsageHandler {
    private static final ResourceLocation SLOT_TEXTURE_LOCATION = new ResourceLocation("nei", "textures/slot.png");
    private static final int OFFSET_X = 2;
    private static final int INFO_OFFSET_Y = 4;
    private static final int ITEMS_OFFSET_Y = 4 + Minecraft.func_71410_x().field_71466_p.field_78288_b * 2 + 6;
    private static final int ROW_ITEM_NUM = 9;
    private final List<ViewItemStack> stacks = new ArrayList<ViewItemStack>();
    private FluidCellInventoryHandler cellHandler;

    public IUsageHandler getUsageHandler(String inputId, Object ... ingredients) {
        Object object;
        if (ingredients.length > 0 && (object = ingredients[0]) instanceof ItemStack) {
            FluidCellInventoryHandler handler;
            ItemStack ingredient = (ItemStack)object;
            object = AEApi.instance().registries().cell().getCellInventory(ingredient, null, StorageChannel.FLUIDS);
            if (object instanceof FluidCellInventoryHandler && (handler = (FluidCellInventoryHandler)object).getTotalBytes() > 0L) {
                this.cellHandler = handler;
                FluidList list = new FluidList();
                handler.getAvailableItems((IItemList)list, IterationCounter.fetchNewId());
                ArrayList<IAEFluidStack> sortedStacks = new ArrayList<IAEFluidStack>();
                list.iterator().forEachRemaining(sortedStacks::add);
                sortedStacks.sort(Comparator.comparing(IAEStack::getStackSize, Comparator.reverseOrder()));
                this.stacks.clear();
                int count = 0;
                for (IAEFluidStack aeFluid : sortedStacks) {
                    FluidStack fluid = aeFluid.getFluidStack();
                    ItemStack fluidItemStack = ItemFluidDrop.newStack(fluid);
                    if (fluidItemStack == null) continue;
                    fluidItemStack.field_77994_a = 1;
                    PositionedStack positionedStack = new PositionedStack((Object)fluidItemStack, 2 + count % 9 * 18 + 1, ITEMS_OFFSET_Y + count / 9 * 18 + 1);
                    this.stacks.add(new ViewItemStack(positionedStack, aeFluid.getStackSize(), fluid.getFluid().getIcon(), fluid.getFluid().getColor()));
                    ++count;
                }
                return this;
            }
        }
        return null;
    }

    public String getRecipeName() {
        return GuiText.CellView.getLocal();
    }

    public int numRecipes() {
        return 1;
    }

    public void drawBackground(int recipe) {
    }

    public void drawForeground(int recipe) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String usedBytes = Platform.formatByteDouble((double)this.cellHandler.getUsedBytes());
        String totalBytes = Platform.formatByteDouble((double)this.cellHandler.getTotalBytes());
        fontRenderer.func_78276_b(usedBytes + " " + GuiText.Of.getLocal() + ' ' + totalBytes + ' ' + GuiText.BytesUsed.getLocal(), 2, 4, 0);
        fontRenderer.func_78276_b(NumberFormat.getInstance().format(this.cellHandler.getUsedTypes()) + " " + GuiText.Of.getLocal() + ' ' + NumberFormat.getInstance().format(this.cellHandler.getTotalTypes()) + ' ' + GuiText.Types.getLocal(), 2, 4 + fontRenderer.field_78288_b + 2, 0);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(SLOT_TEXTURE_LOCATION);
        tessellator.func_78382_b();
        int i = 0;
        while ((long)i < this.cellHandler.getTotalTypes()) {
            int line = i % 9;
            int row = i / 9;
            tessellator.func_78374_a((double)(2 + 18 * (line + 1)), (double)(ITEMS_OFFSET_Y + 18 * row), 0.0, 1.0, 0.0);
            tessellator.func_78374_a((double)(2 + 18 * line), (double)(ITEMS_OFFSET_Y + 18 * row), 0.0, 0.0, 0.0);
            tessellator.func_78374_a((double)(2 + 18 * line), (double)(ITEMS_OFFSET_Y + 18 * (row + 1)), 0.0, 0.0, 1.0);
            tessellator.func_78374_a((double)(2 + 18 * (line + 1)), (double)(ITEMS_OFFSET_Y + 18 * (row + 1)), 0.0, 1.0, 1.0);
            ++i;
        }
        tessellator.func_78381_a();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        tessellator.func_78382_b();
        for (i = 0; i < this.stacks.size(); ++i) {
            IIcon icon = this.stacks.get((int)i).icon;
            int color = this.stacks.get((int)i).color;
            int line = i % 9;
            int row = i / 9;
            if (ModAndClassUtil.HODGEPODGE && icon instanceof IPatchedTextureAtlasSprite) {
                IPatchedTextureAtlasSprite sprite = (IPatchedTextureAtlasSprite)icon;
                sprite.markNeedsAnimationUpdate();
            }
            tessellator.func_78370_a(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
            tessellator.func_78374_a((double)(2 + 18 * (line + 1) - 1), (double)(ITEMS_OFFSET_Y + 18 * row + 1), 0.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
            tessellator.func_78374_a((double)(2 + 18 * line + 1), (double)(ITEMS_OFFSET_Y + 18 * row + 1), 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            tessellator.func_78374_a((double)(2 + 18 * line + 1), (double)(ITEMS_OFFSET_Y + 18 * (row + 1) - 1), 0.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
            tessellator.func_78374_a((double)(2 + 18 * (line + 1) - 1), (double)(ITEMS_OFFSET_Y + 18 * (row + 1) - 1), 0.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        }
        tessellator.func_78381_a();
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        for (ViewItemStack viewStack : this.stacks) {
            StackSizeRenderer.drawStackSize((int)viewStack.stack.relx, (int)viewStack.stack.rely, (long)viewStack.amount, (FontRenderer)fontRenderer, (TerminalFontSize)TerminalFontSize.SMALL);
        }
    }

    public List<PositionedStack> getIngredientStacks(int recipe) {
        return new ArrayList<PositionedStack>();
    }

    public List<PositionedStack> getOtherStacks(int recipe) {
        return this.stacks.stream().map(stack -> stack.stack).collect(Collectors.toList());
    }

    public PositionedStack getResultStack(int recipe) {
        return null;
    }

    public void onUpdate() {
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        return null;
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        return null;
    }

    public int recipiesPerPage() {
        return 1;
    }

    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> currenttip, int recipe) {
        return currenttip;
    }

    public List<String> handleItemTooltip(GuiRecipe<?> gui, ItemStack stack, List<String> currenttip, int recipe) {
        if (stack == null) {
            return currenttip;
        }
        this.stacks.stream().filter(viewStack -> viewStack.stack.item.equals(stack)).findFirst().ifPresent(viewItemStack -> currenttip.set(1, EnumChatFormatting.GRAY + GuiText.Stored.getLocal() + ": " + NumberFormat.getNumberInstance().format(viewItemStack.amount)));
        return currenttip;
    }

    public boolean keyTyped(GuiRecipe<?> gui, char keyChar, int keyCode, int recipe) {
        return false;
    }

    public boolean mouseClicked(GuiRecipe<?> gui, int button, int recipe) {
        return false;
    }

    private static class ViewItemStack {
        public PositionedStack stack;
        public long amount;
        public IIcon icon;
        public int color;

        public ViewItemStack(PositionedStack stack, long amount, IIcon icon, int color) {
            this.stack = stack;
            this.amount = amount;
            this.icon = icon;
            this.color = color;
        }
    }
}

