/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import com.glodblock.github.api.registries.LevelState;
import com.glodblock.github.client.gui.GuiLevelMaintainer;
import com.glodblock.github.common.tile.TileLevelMaintainer;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class SPacketLevelMaintainerGuiUpdate
implements IMessage {
    private Info[] infoList;
    private boolean onlyState;

    public SPacketLevelMaintainerGuiUpdate() {
    }

    public SPacketLevelMaintainerGuiUpdate(TileLevelMaintainer.RequestInfo[] requests, boolean onlyState) {
        this.infoList = new Info[5];
        this.onlyState = onlyState;
        for (int i = 0; i < 5; ++i) {
            this.infoList[i] = requests[i] == null ? null : new Info(requests[i].getQuantity(), requests[i].getBatchSize(), requests[i].isEnable(), requests[i].getState());
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.infoList = new Info[5];
        this.onlyState = buf.readBoolean();
        for (int i = 0; i < 5; ++i) {
            if (buf.readBoolean()) {
                if (this.onlyState) {
                    this.infoList[i] = new Info(LevelState.values()[buf.readInt()]);
                    continue;
                }
                this.infoList[i] = new Info(buf.readLong(), buf.readLong(), buf.readBoolean(), LevelState.values()[buf.readInt()]);
                continue;
            }
            this.infoList[i] = null;
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.onlyState);
        for (Info info : this.infoList) {
            buf.writeBoolean(info != null);
            if (info == null) continue;
            if (!this.onlyState) {
                buf.writeLong(info.quantity);
                buf.writeLong(info.batchSize);
                buf.writeBoolean(info.enable);
            }
            buf.writeInt(info.state.ordinal());
        }
    }

    private static class Info {
        long quantity;
        long batchSize;
        boolean enable;
        LevelState state;

        Info(long quantity, long batchSize, boolean enable, LevelState state) {
            this.quantity = quantity;
            this.batchSize = batchSize;
            this.enable = enable;
            this.state = state;
        }

        Info(LevelState state) {
            this.quantity = 0L;
            this.batchSize = 0L;
            this.enable = false;
            this.state = state;
        }
    }

    public static class Handler
    implements IMessageHandler<SPacketLevelMaintainerGuiUpdate, IMessage> {
        public IMessage onMessage(SPacketLevelMaintainerGuiUpdate message, MessageContext ctx) {
            GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
            if (gs instanceof GuiLevelMaintainer) {
                GuiLevelMaintainer gui = (GuiLevelMaintainer)gs;
                for (int i = 0; i < 5; ++i) {
                    Info info = message.infoList[i];
                    if (info == null) continue;
                    if (message.onlyState) {
                        gui.updateComponent(i, info.state);
                        continue;
                    }
                    gui.updateComponent(i, info.quantity, info.batchSize, info.enable, info.state);
                }
            }
            return null;
        }
    }
}

