/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.util;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPos {
    private final int x;
    private final int y;
    private final int z;
    private final World w;

    public BlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = null;
    }

    public BlockPos(int x, int y, int z, World w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public BlockPos(@Nonnull TileEntity te) {
        this.x = te.field_145851_c;
        this.y = te.field_145848_d;
        this.z = te.field_145849_e;
        this.w = te.func_145831_w();
    }

    public BlockPos getOffSet(ForgeDirection face) {
        return new BlockPos(this.x + face.offsetX, this.y + face.offsetY, this.z + face.offsetZ, this.w);
    }

    public BlockPos getOffSet(int x, int y, int z) {
        return new BlockPos(this.x + x, this.y + y, this.z + z, this.w);
    }

    public TileEntity getTileEntity() {
        if (this.w != null) {
            return this.w.func_147438_o(this.x, this.y, this.z);
        }
        return null;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public World getWorld() {
        return this.w;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockPos) {
            BlockPos pos = (BlockPos)obj;
            return pos.x == this.x && pos.y == this.y && pos.z == this.z && Objects.equals(pos.w, this.w);
        }
        return false;
    }
}

