/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.misc;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationBackpack {
    public static Configuration config;
    public static int ENDER_RECIPE;
    public static int BACKPACK_SLOTS_S;
    public static int BACKPACK_SLOTS_L;
    public static int BACKPACK_SLOTS_M;
    public static int MAX_BACKPACK_AMOUNT;
    public static boolean RENDER_BACKPACK_MODEL;
    public static boolean OPEN_ONLY_PERSONAL_BACKPACK;
    public static boolean AIRSHIP_MOD_COMPATIBILITY;
    public static boolean DISABLE_BACKPACKS;
    public static boolean DISABLE_BIG_BACKPACKS;
    public static boolean DISABLE_ENDER_BACKPACKS;
    public static boolean DISABLE_WORKBENCH_BACKPACKS;
    public static boolean BIG_BY_UPGRADE_ONLY;
    public static String[] DISALLOW_ITEM_IDS;
    public static String[] FORBIDDEN_DIMENSIONS;
    public static String[] DEFAULT_IDS;
    public static boolean ALLOW_SOULBOUND;
    public static boolean NEISupport;
    public static boolean PLAY_OPEN_SOUND;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            ConfigurationBackpack.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        ENDER_RECIPE = config.get("general", "enderRecipe", 0, ConfigurationBackpack.getEnderRecipeComment()).getInt();
        if (ENDER_RECIPE < 0 || ENDER_RECIPE > 1) {
            ENDER_RECIPE = 0;
        }
        if ((BACKPACK_SLOTS_S = config.get("general", "backpackSlotsS", 27, ConfigurationBackpack.getBackpackSlotComment("small")).getInt()) < 1 || BACKPACK_SLOTS_S > 128) {
            BACKPACK_SLOTS_S = 27;
        }
        if ((BACKPACK_SLOTS_M = config.get("general", "backpackSlotsM", 36, ConfigurationBackpack.getBackpackSlotComment("medium")).getInt()) < 1 || BACKPACK_SLOTS_M > 128) {
            BACKPACK_SLOTS_M = 36;
        }
        if ((BACKPACK_SLOTS_L = config.get("general", "backpackSlotsL", 54, ConfigurationBackpack.getBackpackSlotComment("large")).getInt()) < 1 || BACKPACK_SLOTS_L > 128) {
            BACKPACK_SLOTS_L = 54;
        }
        if ((MAX_BACKPACK_AMOUNT = config.get("general", "maxBackpackAmount", 0, ConfigurationBackpack.getMaxBackpackAmountComment()).getInt()) < 0 || MAX_BACKPACK_AMOUNT > 36) {
            MAX_BACKPACK_AMOUNT = 0;
        }
        RENDER_BACKPACK_MODEL = config.get("general", "renderBackpackModel", true, ConfigurationBackpack.getRenderBackpackModelComment()).getBoolean(true);
        OPEN_ONLY_PERSONAL_BACKPACK = config.get("general", "openOnlyWornBackpacks", false, ConfigurationBackpack.getOpenOnlyPersonalBackpacksComment()).getBoolean(false);
        AIRSHIP_MOD_COMPATIBILITY = config.get("general", "airshipModCompatibility", false, ConfigurationBackpack.getAirshipModCompatibilityComment()).getBoolean(false);
        DISABLE_BACKPACKS = config.get("general", "disableBackpacks", false, ConfigurationBackpack.getDisableBackpacksComment()).getBoolean(false);
        DISABLE_BIG_BACKPACKS = config.get("general", "disableBigBackpacks", false, ConfigurationBackpack.getDisableBigBackpacksComment()).getBoolean(false);
        DISABLE_ENDER_BACKPACKS = config.get("general", "disableEnderBackpack", false, ConfigurationBackpack.getDisableEnderBackpacksComment()).getBoolean(false);
        DISABLE_WORKBENCH_BACKPACKS = config.get("general", "disableWorkbenchBackpack", false, ConfigurationBackpack.getDisableWorkbenchBackpacksComment()).getBoolean(false);
        BIG_BY_UPGRADE_ONLY = config.get("general", "bigByUpgradeOnly", false, ConfigurationBackpack.getBigByUpgradeOnlyComment()).getBoolean(false);
        DISALLOW_ITEM_IDS = config.get("general", "disallowItems", DEFAULT_IDS, ConfigurationBackpack.getDisallowItemsComment()).getStringList();
        FORBIDDEN_DIMENSIONS = config.get("general", "forbiddenDimensions", DEFAULT_IDS, ConfigurationBackpack.getForbiddenDimensionsComment()).getStringList();
        PLAY_OPEN_SOUND = config.get("general", "playSound", true, ConfigurationBackpack.getPlaySoundComment()).getBoolean(true);
        ALLOW_SOULBOUND = config.get("general", "allowSoulbound", true, ConfigurationBackpack.getAllowSoulboundComment()).getBoolean(false);
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static String getEnderRecipeComment() {
        return "##############\nRecipe to craft ender backpack\n0 ender chest\n1 eye of the ender\n##############";
    }

    private static String getBackpackSlotComment(String type) {
        return "##############\nNumber of slots a " + type + " backpack has\nvalid: integers 1-128\n##############";
    }

    private static String getMaxBackpackAmountComment() {
        return "##############\nNumber of backpacks a player can have in his inventory\nvalid: integers 0-36\n0 = unlimited\n##############";
    }

    private static String getRenderBackpackModelComment() {
        return "##############\nIf true the backpack 3D model will be rendered.\n##############";
    }

    private static String getOpenOnlyPersonalBackpacksComment() {
        return "##############\nIf true you can only open a backpack that you wear in the extra slot\n##############";
    }

    private static String getAirshipModCompatibilityComment() {
        return "##############\nIf true normal backpack requires a chest in the middle\n##############";
    }

    private static String getDisableBackpacksComment() {
        return "##############\nIf true small backpacks are not craftable\n##############";
    }

    private static String getDisableBigBackpacksComment() {
        return "##############\nIf true big backpacks are not craftable\n##############";
    }

    private static String getDisableEnderBackpacksComment() {
        return "##############\nIf true ender backpacks are not craftable\n##############";
    }

    private static String getDisableWorkbenchBackpacksComment() {
        return "##############\nIf true workbench backpacks are not craftable\n##############";
    }

    private static String getBigByUpgradeOnlyComment() {
        return "##############\nIf true big backpacks can only crafted by upgrading a small one\n##############";
    }

    private static String getDisallowItemsComment() {
        return "##############\nExample:\ndisallowItems: minecraft:dirt\n\nThis will disallow dirt in backpacks.\n##############";
    }

    private static String getForbiddenDimensionsComment() {
        return "##############\nExample:\nforbiddenDimensions: 0\n\nThis will disallow backpacks inventory for Overworld (id = 0).\n##############";
    }

    private static String getPlaySoundComment() {
        return "##############\nIf true backpack will play opening sound effect\n##############";
    }

    private static String getAllowSoulboundComment() {
        return "##############\nIf true backpack will stay in your backpack slot on death when enchanted with EnderIO soulbound.\n##############";
    }

    static {
        DEFAULT_IDS = new String[0];
        NEISupport = false;
        PLAY_OPEN_SOUND = false;
    }
}

