/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.Handler.Spectre;

import java.util.ArrayList;
import java.util.HashMap;
import lumien.randomthings.Blocks.ModBlocks;
import lumien.randomthings.Configuration.Settings;
import lumien.randomthings.Handler.Spectre.TeleporterSpectre;
import lumien.randomthings.Library.WorldUtils;
import lumien.randomthings.Mixins.early.EntityAccessor;
import lumien.randomthings.Network.Messages.MessageSpectreData;
import lumien.randomthings.Network.PacketHandler;
import lumien.randomthings.RandomThings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.Level;

public class SpectreHandler
extends WorldSavedData {
    int nextCoord = 0;
    int spectreDimensionID;
    HashMap<String, Integer> playerConnection = new HashMap();
    World worldObj;

    public SpectreHandler() {
        this("SpectreHandler");
    }

    public SpectreHandler(String s) {
        super("SpectreHandler");
        this.spectreDimensionID = Settings.SPECTRE_DIMENSON_ID;
    }

    public void setWorld(World w) {
        this.worldObj = w;
    }

    public void sendOperator(EntityPlayer operator, String cubeOwner) {
        if (MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(operator.func_146103_bH())) {
            if (!this.playerConnection.containsKey(cubeOwner)) {
                operator.func_146105_b((IChatComponent)new ChatComponentText(cubeOwner + " does not have a cube in the spectre dimension"));
            } else {
                WorldServer spectreWorld = MinecraftServer.func_71276_C().func_71218_a(Settings.SPECTRE_DIMENSON_ID);
                int coord = this.playerConnection.get(cubeOwner);
                if (operator.field_71093_bK != Settings.SPECTRE_DIMENSON_ID) {
                    MinecraftServer.func_71276_C().func_71203_ab().transferPlayerToDimension((EntityPlayerMP)operator, Settings.SPECTRE_DIMENSON_ID, (Teleporter)new TeleporterSpectre(spectreWorld));
                }
                operator.func_70634_a((double)(coord * 32 + 9 - 1), 42.0, 1.5);
            }
        }
    }

    public void teleportPlayerToSpectreWorld(EntityPlayerMP player) {
        int coord;
        String playerName = player.func_70005_c_();
        WorldServer spectreWorld = MinecraftServer.func_71276_C().func_71218_a(Settings.SPECTRE_DIMENSON_ID);
        if (this.playerConnection.containsKey(playerName)) {
            coord = this.playerConnection.get(playerName);
        } else {
            coord = this.nextCoord++;
            WorldUtils.generateCube((World)spectreWorld, coord * 32, 40, 0, coord * 32 + 15, 52, 15, ModBlocks.spectreBlock, 12, 2);
            this.playerConnection.put(playerName, coord);
            this.func_76185_a();
        }
        if (player.field_71093_bK != Settings.SPECTRE_DIMENSON_ID) {
            MinecraftServer.func_71276_C().func_71203_ab().transferPlayerToDimension(player, Settings.SPECTRE_DIMENSON_ID, (Teleporter)new TeleporterSpectre(spectreWorld));
        }
        player.func_70634_a((double)(coord * 32 + 9 - 1), 42.0, 1.5);
    }

    public void func_76187_b(NBTTagCompound nbt) {
        nbt.func_74768_a("nextCoord", this.nextCoord);
        nbt.func_74768_a("spectreDimensionID", this.spectreDimensionID);
        NBTTagList tagList = new NBTTagList();
        for (String playerName : this.playerConnection.keySet()) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("playerName", playerName);
            int position = this.playerConnection.get(playerName);
            compound.func_74768_a("position", position);
            tagList.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("playerList", (NBTBase)tagList);
        nbt.func_74757_a("newVersion", true);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.nextCoord = nbt.func_74762_e("nextCoord");
        this.spectreDimensionID = nbt.func_74762_e("spectreDimensionID");
        NBTTagList tagList = nbt.func_150295_c("playerList", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound compound = tagList.func_150305_b(i);
            String playerName = compound.func_74779_i("playerName");
            int position = compound.func_74762_e("position");
            this.playerConnection.put(playerName, position);
        }
        boolean newVersion = nbt.func_74767_n("newVersion");
        if (!newVersion) {
            this.reset();
            RandomThings.instance.logger.log(Level.WARN, "The Spectre World got an update in the recent version so i had to \"reset\" the spectre world.");
            RandomThings.instance.logger.log(Level.WARN, "I would recommend to also reset the spectre world itself because the \"old\" cubes are still where they were");
            RandomThings.instance.logger.log(Level.WARN, "Also if there's still a player in the old spectre world you should either move him out or change the dimensionID to 32 in the config file");
            RandomThings.instance.logger.log(Level.WARN, "If you don't this will crash in a second!! :(");
        }
        if (this.spectreDimensionID != Settings.SPECTRE_DIMENSON_ID) {
            RandomThings.instance.logger.log(Level.WARN, "Resetting Spectre World because dimensionID changed (" + this.spectreDimensionID + "->" + Settings.SPECTRE_DIMENSON_ID + ")");
            this.spectreDimensionID = Settings.SPECTRE_DIMENSON_ID;
            this.reset();
            this.func_76185_a();
        }
    }

    public void teleportPlayerOutOfSpectreWorld(EntityPlayerMP player) {
        if (((EntityAccessor)player).getCustomEntityData() != null) {
            NBTTagCompound nbt = player.getEntityData();
            if (nbt.func_74764_b("oldPosX")) {
                int oldDimension = nbt.func_74762_e("oldDimension");
                double oldPosX = nbt.func_74769_h("oldPosX");
                double oldPosY = nbt.func_74769_h("oldPosY");
                double oldPosZ = nbt.func_74769_h("oldPosZ");
                MinecraftServer.func_71276_C().func_71203_ab().transferPlayerToDimension(player, oldDimension, (Teleporter)new TeleporterSpectre(MinecraftServer.func_71276_C().func_71218_a(oldDimension)));
                player.func_70634_a(oldPosX, oldPosY, oldPosZ);
            } else {
                ChunkCoordinates cc = MinecraftServer.func_71276_C().func_71218_a((int)0).field_73011_w.getRandomizedSpawnPoint();
                MinecraftServer.func_71276_C().func_71203_ab().transferPlayerToDimension(player, 0, (Teleporter)new TeleporterSpectre(MinecraftServer.func_71276_C().func_71218_a(0)));
                player.func_70634_a((double)cc.field_71574_a, (double)cc.field_71572_b, (double)cc.field_71573_c);
            }
        } else {
            ChunkCoordinates cc = MinecraftServer.func_71276_C().func_71218_a((int)0).field_73011_w.getRandomizedSpawnPoint();
            MinecraftServer.func_71276_C().func_71203_ab().transferPlayerToDimension(player, 0, (Teleporter)new TeleporterSpectre(MinecraftServer.func_71276_C().func_71218_a(0)));
            player.func_70634_a((double)cc.field_71574_a, (double)cc.field_71572_b, (double)cc.field_71573_c);
        }
    }

    public void update() {
        if (this.worldObj.func_82737_E() % 10L == 0L) {
            for (int i = 0; i < this.worldObj.field_73010_i.size(); ++i) {
                if (!(this.worldObj.field_73010_i.get(i) instanceof EntityPlayer)) continue;
                EntityPlayer player = (EntityPlayer)this.worldObj.field_73010_i.get(i);
                if (MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(player.func_146103_bH())) continue;
                String username = player.func_70005_c_();
                if (this.playerConnection.containsKey(username)) {
                    int coord = this.playerConnection.get(username);
                    AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(coord * 32), (double)40.0, (double)0.0, (double)(coord * 32 + 15), (double)52.0, (double)15.0);
                    if (bb.func_72318_a(Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v))) continue;
                    player.func_70634_a((double)(coord * 32 + 9 - 1), 42.0, 1.5);
                    player.func_70690_d(new PotionEffect(2, 200, 5, false));
                    continue;
                }
                ChunkCoordinates cc = MinecraftServer.func_71276_C().func_71218_a((int)0).field_73011_w.getRandomizedSpawnPoint();
                MinecraftServer.func_71276_C().func_71203_ab().transferPlayerToDimension((EntityPlayerMP)player, 0, (Teleporter)new TeleporterSpectre(MinecraftServer.func_71276_C().func_71218_a(0)));
                player.func_70634_a((double)cc.field_71574_a, (double)cc.field_71572_b, (double)cc.field_71573_c);
            }
        }
    }

    public void reset() {
        this.playerConnection = new HashMap();
        this.nextCoord = 0;
        this.func_76185_a();
    }

    public void sendData(EntityPlayer player) {
        PacketHandler.INSTANCE.sendTo(new MessageSpectreData(new ArrayList<String>(this.playerConnection.keySet())), (EntityPlayerMP)player);
    }
}

