/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.navigator.impl;

import com.gtnewhorizons.navigator.api.model.locations.IWaypointAndLocationProvider;
import com.gtnewhorizons.navigator.api.model.waypoints.Waypoint;
import com.gtnewhorizons.navigator.api.util.Util;

public class DirtyChunkLocation
implements IWaypointAndLocationProvider {
    private final int blockX;
    private final int blockZ;
    private final int dimensionId;
    private boolean dirty;
    private boolean isActiveAsWaypoint;

    public DirtyChunkLocation(int chunkX, int chunkZ, int dimensionId, boolean dirty) {
        this.blockX = Util.coordChunkToBlock(chunkX);
        this.blockZ = Util.coordChunkToBlock(chunkZ);
        this.dimensionId = dimensionId;
        this.dirty = dirty;
    }

    @Override
    public double getBlockX() {
        return (double)this.blockX + 0.5;
    }

    @Override
    public double getBlockZ() {
        return (double)this.blockZ + 0.5;
    }

    @Override
    public int getDimensionId() {
        return this.dimensionId;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public Waypoint toWaypoint() {
        return new Waypoint(this.blockX, 64, this.blockZ, this.getDimensionId(), "Example Waypoint", 0xFFFFFF);
    }

    @Override
    public boolean isActiveAsWaypoint() {
        return this.isActiveAsWaypoint;
    }

    @Override
    public void onWaypointCleared() {
        this.isActiveAsWaypoint = false;
    }

    @Override
    public void onWaypointUpdated(Waypoint waypoint) {
        this.isActiveAsWaypoint = waypoint.dimensionId == this.dimensionId && waypoint.blockX == this.blockX && waypoint.blockZ == this.blockZ;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

