/*
 * Decompiled with CFR 0.152.
 */
package com.github.namikon.blocklimiter.events;

import com.github.namikon.blocklimiter.BlockLimiter;
import com.github.namikon.blocklimiter.auxiliary.ItemInfo;
import com.github.namikon.blocklimiter.config.BlockLimiterConfig;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import eu.usrv.yamcore.auxiliary.ItemDescriptor;
import eu.usrv.yamcore.auxiliary.PlayerChatHelper;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class ItemUseEvent {
    private BlockLimiterConfig _mConfig = null;
    private Random _mRnd = null;

    public ItemUseEvent(BlockLimiterConfig pCfgMan) {
        this._mConfig = pCfgMan;
        this._mRnd = new Random();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onInteractEvent(PlayerInteractEvent pEvent) {
        if (pEvent.entityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        if (pEvent.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK || !pEvent.isCancelable()) {
            return;
        }
        if (pEvent.entityPlayer.field_71075_bZ.field_75098_d && BlockLimiter.Config.DenyCreativeMode) {
            return;
        }
        if (pEvent.entityPlayer != null && pEvent.entityPlayer.func_71045_bC() != null) {
            ItemDescriptor tID = ItemDescriptor.fromStack((ItemStack)pEvent.entityPlayer.func_71045_bC());
            if (tID == null) {
                return;
            }
            BlockLimiter.Logger.debug((Object)String.format("Usage of item: %s", tID.toString()));
            for (ItemInfo tII : this._mConfig.LimitedItems) {
                if (!tII.isDenied(tID, pEvent.entityPlayer.field_71093_bK)) continue;
                pEvent.setCanceled(true);
                try {
                    if (BlockLimiter.Config.SFXOnItemDeny.length() > 0) {
                        pEvent.entityPlayer.field_70170_p.func_72956_a((Entity)pEvent.entityPlayer, BlockLimiter.Config.SFXOnItemDeny, 1.0f, 1.0f);
                    }
                    int tMsgIdx = this._mRnd.nextInt(BlockLimiter.Config.RandomItemDenyMessages.length);
                    PlayerChatHelper.SendNotifyWarning((EntityPlayer)pEvent.entityPlayer, (String)BlockLimiter.Config.RandomItemDenyMessages[tMsgIdx]);
                }
                catch (Exception e) {
                    BlockLimiter.Logger.error((Object)"Prevented ServerCrash caused by malformed RejectMessage or SoundSetting in the config file");
                }
            }
        }
    }
}

