/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.api.harvesting;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import tconstruct.api.harvesting.CropHarvestHandler;
import tconstruct.api.harvesting.CropHarvestHandlers;
import tconstruct.items.tools.Scythe;
import tconstruct.library.tools.AbilityHelper;

public class AoeCropHarvestHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void handlePlayerInteractEvent(PlayerInteractEvent event) {
        ItemStack equippedItem = event.entityPlayer.func_71045_bC();
        if (!event.world.field_72995_K && AoeCropHarvestHandler.isScythe(equippedItem) && AoeCropHarvestHandler.harvestCropsInRange(equippedItem, event.entityPlayer, event.world, event.x, event.y, event.z)) {
            event.setCanceled(true);
        }
    }

    private static boolean isScythe(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof Scythe;
    }

    private static boolean harvestCropsInRange(ItemStack stack, EntityPlayer player, World world, int x, int y, int z) {
        boolean harvesting = AoeCropHarvestHandler.canPlayerHarvestCrop(world, x, y, z);
        if (harvesting) {
            if (player.func_70093_af()) {
                AoeCropHarvestHandler.tryHarvestCrop(stack, player, world, x, y, z);
            } else {
                AoeCropHarvestHandler.harvestInAoe(stack, player, world, x, y, z);
            }
        }
        return harvesting;
    }

    private static boolean canPlayerHarvestCrop(World world, int x, int y, int z) {
        for (CropHarvestHandler handler : CropHarvestHandlers.getCropHarvestHandlers()) {
            if (!handler.couldHarvest(world, x, y, z)) continue;
            return true;
        }
        return false;
    }

    private static void harvestInAoe(ItemStack stack, EntityPlayer player, World world, int x, int y, int z) {
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                for (int k = -2; k < 3; ++k) {
                    if (stack.func_77978_p().func_74775_l("InfiTool").func_74767_n("Broken")) continue;
                    AoeCropHarvestHandler.tryHarvestCrop(stack, player, world, x + i, y + j, z + k);
                }
            }
        }
    }

    private static void tryHarvestCrop(ItemStack stack, EntityPlayer player, World world, int x, int y, int z) {
        for (CropHarvestHandler handler : CropHarvestHandlers.getCropHarvestHandlers()) {
            if (!handler.couldHarvest(world, x, y, z)) continue;
            boolean harvestSuccessful = handler.tryHarvest(stack, player, world, x, y, z);
            if (harvestSuccessful && !player.field_71075_bZ.field_75098_d) {
                AbilityHelper.damageTool(stack, 1, null, false);
            }
            return;
        }
    }
}

