/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.inventory;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import tconstruct.smeltery.TinkerSmeltery;
import tconstruct.smeltery.inventory.ActiveContainer;
import tconstruct.smeltery.inventory.ActiveSlot;
import tconstruct.smeltery.logic.SmelteryLogic;

public class SmelteryContainer
extends ActiveContainer {
    public SmelteryLogic logic;
    public InventoryPlayer playerInv;
    public int fuel = 0;
    private int slotRow;
    public int columns;
    public final int smelterySize;

    public SmelteryContainer(InventoryPlayer inventoryplayer, SmelteryLogic smeltery) {
        this.logic = smeltery;
        this.playerInv = inventoryplayer;
        this.slotRow = 0;
        this.columns = smeltery.getBlocksPerLayer() >= 16 ? 4 : 3;
        this.smelterySize = smeltery.getBlockCapacity();
        int totalSlots = smeltery.getBlockCapacity();
        int y = 0;
        for (int i = 0; i < totalSlots; ++i) {
            int x = i % this.columns;
            this.addDualSlotToContainer(new ActiveSlot((IInventory)smeltery, x + y * this.columns, 2 + x * 22, 8 + y * 18, y < 8));
            if (x != this.columns - 1) continue;
            ++y;
        }
        int baseX = 90 + (this.columns - 3) * 22;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.func_75146_a(new Slot((IInventory)inventoryplayer, column + row * 9 + 9, baseX + column * 18, 84 + row * 18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.func_75146_a(new Slot((IInventory)inventoryplayer, column, baseX + column * 18, 142));
        }
    }

    public int updateRows(int invRow) {
        if (invRow != this.slotRow) {
            this.slotRow = invRow;
            int basePos = invRow * this.columns;
            for (int iter = 0; iter < this.activeInventorySlots.size(); ++iter) {
                ActiveSlot slot = (ActiveSlot)((Object)this.activeInventorySlots.get(iter));
                slot.setActive(slot.activeSlotNumber >= basePos && slot.activeSlotNumber < basePos + this.columns * 8);
                int xPos = (iter - basePos) % this.columns;
                int yPos = (iter - basePos) / this.columns;
                slot.field_75223_e = 2 + 22 * xPos;
                slot.field_75221_f = 8 + 18 * yPos;
            }
            return this.slotRow;
        }
        return -1;
    }

    public int scrollTo(float scrollPos) {
        int slots = 8 * this.columns;
        float total = (this.logic.func_70302_i_() - slots) / this.columns;
        if ((this.logic.func_70302_i_() - slots) % this.columns != 0) {
            total += 1.0f;
        }
        int rowPos = Math.round(total * scrollPos);
        return this.updateRows(rowPos);
    }

    public void func_75142_b() {
        if (this.smelterySize == this.field_75151_b.size()) {
            super.func_75142_b();
        }
    }

    public void func_75137_b(int id, int value) {
        if (id == 0) {
            this.logic.fuelGague = value;
        }
    }

    @Override
    public boolean func_75145_c(EntityPlayer entityplayer) {
        Block block = this.logic.func_145831_w().func_147439_a(this.logic.field_145851_c, this.logic.field_145848_d, this.logic.field_145849_e);
        if (block != TinkerSmeltery.smeltery && block != TinkerSmeltery.smelteryNether) {
            return false;
        }
        return this.logic.func_70300_a(entityplayer);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotID) {
        ItemStack stack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotID);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (slotID < this.smelterySize ? !this.func_75135_a(slotStack, this.logic.func_70302_i_(), this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, this.smelterySize, false)) {
                return null;
            }
            if (slotStack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
        }
        return stack;
    }

    protected boolean func_75135_a(ItemStack inputStack, int startSlot, int endSlot, boolean flag) {
        ItemStack slotStack;
        Slot slot;
        boolean merged = false;
        int slotPos = startSlot;
        if (flag) {
            slotPos = endSlot - 1;
        }
        if (inputStack.func_77985_e() && startSlot >= this.logic.func_70302_i_()) {
            while (inputStack.field_77994_a > 0 && (!flag && slotPos < endSlot || flag && slotPos >= startSlot)) {
                slot = (Slot)this.field_75151_b.get(slotPos);
                slotStack = slot.func_75211_c();
                if (slotStack != null && slotStack.func_77969_a(inputStack) && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)inputStack)) {
                    int l = slotStack.field_77994_a + inputStack.field_77994_a;
                    if (l <= inputStack.func_77976_d()) {
                        inputStack.field_77994_a = 0;
                        slotStack.field_77994_a = l;
                        slot.func_75218_e();
                        merged = true;
                    } else if (slotStack.field_77994_a < inputStack.func_77976_d()) {
                        inputStack.field_77994_a -= inputStack.func_77976_d() - slotStack.field_77994_a;
                        slotStack.field_77994_a = inputStack.func_77976_d();
                        slot.func_75218_e();
                        merged = true;
                    }
                }
                if (flag) {
                    --slotPos;
                    continue;
                }
                ++slotPos;
            }
        }
        if (inputStack.field_77994_a > 0) {
            slotPos = flag ? endSlot - 1 : startSlot;
            while (!flag && slotPos < endSlot || flag && slotPos >= startSlot) {
                slot = (Slot)this.field_75151_b.get(slotPos);
                slotStack = slot.func_75211_c();
                if (slotStack == null) {
                    slot.func_75215_d(inputStack.func_77946_l());
                    slot.func_75218_e();
                    --inputStack.field_77994_a;
                    merged = true;
                    break;
                }
                if (flag) {
                    --slotPos;
                    continue;
                }
                ++slotPos;
            }
        }
        return merged;
    }
}

