/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft;

import com.pam.harvestcraft.ItemRegistry;
import com.pam.harvestcraft.PamUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class QuernRecipes {
    private static final QuernRecipes smeltingBase = new QuernRecipes();
    private final Map<ItemStack, ItemStack> smeltingList = new HashMap<ItemStack, ItemStack>();
    private final Map<ItemStack, Float> experienceList = new HashMap<ItemStack, Float>();

    private QuernRecipes() {
        this.addSmelting(Items.field_151015_O, new ItemStack(ItemRegistry.flourItem), 0.1f);
        this.addSmelting(Items.field_151174_bG, new ItemStack(ItemRegistry.flourItem), 0.1f);
        this.addSmelting(ItemRegistry.riceItem, new ItemStack(ItemRegistry.flourItem), 0.1f);
        this.addSmelting(ItemRegistry.barleyItem, new ItemStack(ItemRegistry.flourItem), 0.1f);
        this.addSmelting(ItemRegistry.oatsItem, new ItemStack(ItemRegistry.flourItem), 0.1f);
        this.addSmelting(ItemRegistry.ryeItem, new ItemStack(ItemRegistry.flourItem), 0.1f);
        this.addSmeltingRecipe(new ItemStack(Items.field_151100_aR, 0, 3), new ItemStack(ItemRegistry.cocoapowderItem), 0.1f);
        this.addSmelting(ItemRegistry.cinnamonItem, new ItemStack(ItemRegistry.groundcinnamonItem), 0.1f);
        this.addSmelting(ItemRegistry.nutmegItem, new ItemStack(ItemRegistry.groundnutmegItem), 0.1f);
        this.addSmelting(ItemRegistry.peppercornItem, new ItemStack(ItemRegistry.blackpepperItem), 0.1f);
        this.addSmelting(ItemRegistry.curryleafItem, new ItemStack(ItemRegistry.currypowderItem), 0.1f);
    }

    public static QuernRecipes smelting() {
        return smeltingBase;
    }

    public void addSmeltingRecipeForBlock(Block input, ItemStack stack, float experience) {
        this.addSmelting(Item.func_150898_a((Block)input), stack, experience);
    }

    public void addSmelting(Item input, ItemStack stack, float experience) {
        this.addSmeltingRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack, experience);
    }

    public void addSmeltingRecipe(ItemStack input, ItemStack stack, float experience) {
        this.smeltingList.put(input, stack);
        this.experienceList.put(stack, Float.valueOf(experience));
    }

    public ItemStack getSmeltingResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.smeltingList.entrySet()) {
            if (!PamUtils.areItemStacksEqualWithWildcard(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<ItemStack, ItemStack> getSmeltingList() {
        return this.smeltingList;
    }

    public float getSmeltingExperience(ItemStack stack) {
        float ret = stack.func_77973_b().getSmeltingExperience(stack);
        if (ret != -1.0f) {
            return ret;
        }
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!PamUtils.areItemStacksEqualWithWildcard(stack, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }
}

