/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.gui.buttons;

import com.leobeliik.extremesoundmuffler.Config;
import com.leobeliik.extremesoundmuffler.SoundMuffler;
import com.leobeliik.extremesoundmuffler.gui.MainScreen;
import com.leobeliik.extremesoundmuffler.gui.buttons.ESMButton;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.leobeliik.extremesoundmuffler.utils.Anchor;
import com.leobeliik.extremesoundmuffler.utils.Icon;
import com.leobeliik.extremesoundmuffler.utils.PlayButtonSound;
import com.leobeliik.extremesoundmuffler.utils.SliderSound;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class MuffledSlider
extends ESMButton
implements ISoundLists {
    private final Anchor anchor;
    private float sliderValue;
    private ESMButton btnToggleSound;
    private final ResourceLocation sound;
    public static SliderSound tickSound;
    public static boolean showSlider;
    private boolean isDragging;
    private final List<ESMButton> subButtons = new ArrayList<ESMButton>();
    private boolean muffled = false;

    public MuffledSlider(int id, int x, int y, int width, int height, float sliderValue, ResourceLocation sound, Anchor anchor) {
        super(id, x, y, width, height, sound.toString());
        this.sliderValue = sliderValue;
        this.sound = sound;
        this.anchor = anchor;
        this.refreshButtons();
    }

    @Override
    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return;
        }
        SoundMuffler.renderGui();
        this.setTextColor(this.muffled ? 65535 : 0xFFFFFF);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDisable((int)2896);
        this.drawGradient(mouseX, mouseY);
        this.drawButtonHighlight();
        this.drawSubButtons(mc, mouseX, mouseY);
        this.drawMessage(mc, mouseX, mouseY);
        this.func_146119_b(mc, mouseX, mouseY);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawButtonHighlight() {
        int bW;
        int x = Config.getLeftButtons() ? this.field_146128_h - 3 : this.field_146128_h + 1;
        int n = bW = Config.getLeftButtons() ? x + this.field_146120_f + 5 : x + this.field_146120_f + 28;
        if (this.field_146127_k % 2 == 0 && this.isVisible()) {
            MuffledSlider.func_73734_a((int)x, (int)this.field_146129_i, (int)bW, (int)(this.field_146129_i + this.field_146121_g), (int)0x4E464646);
        }
    }

    private void drawMessage(Minecraft minecraft, int mouseX, int mouseY) {
        FontRenderer font = minecraft.field_71466_p;
        int v = Math.max(this.field_146120_f, font.func_78256_a(this.field_146126_j));
        if (showSlider && this.isVisible() && this.isMouseOver(mouseX, mouseY)) {
            this.func_73732_a(font, "Volume: " + (int)(this.sliderValue * 100.0f), this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + 2, 0xFFFFFF);
        } else {
            String msgTruncated;
            if (this.isMouseOver(mouseX, mouseY)) {
                msgTruncated = this.field_146126_j;
                MuffledSlider.func_73734_a((int)(this.field_146128_h + this.field_146120_f + 3), (int)this.field_146129_i, (int)(this.field_146128_h + v + 3), (int)(this.field_146129_i + font.field_78288_b + 2), (int)-1157627904);
            } else {
                msgTruncated = font.func_78269_a(this.field_146126_j, 205);
            }
            font.func_78261_a(msgTruncated, this.field_146128_h + 2, this.field_146129_i + 2, this.textColor);
        }
    }

    private void drawGradient(int mouseX, int mouseY) {
        if (this.muffled) {
            this.func_73729_b(this.field_146128_h, this.field_146129_i - 1, 0, 234, (int)(this.sliderValue * (float)(this.field_146120_f - 6)) + 5, this.field_146121_g + 1);
            if (this.isMouseOver(mouseX, mouseY) && showSlider) {
                this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (float)(this.field_146120_f - 6)) + 1, this.field_146129_i + 1, 32, 224, 5, 9);
            }
        }
    }

    private void drawSubButtons(Minecraft mc, int mouseX, int mouseY) {
        this.btnToggleSound.setIcon(this.muffled ? Icon.MUFFLE_ON : Icon.MUFFLE_OFF);
        for (GuiButton guiButton : this.subButtons) {
            guiButton.func_146112_a(mc, mouseX, mouseY);
        }
    }

    public void refreshButtons() {
        SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
        this.subButtons.clear();
        int x = Config.getLeftButtons() ? this.field_146128_h - 24 : this.field_146128_h + this.field_146120_f + 5;
        this.btnToggleSound = new ESMButton(0, x, this.field_146129_i, 11, 11, "", this::toggleSound);
        this.subButtons.add(this.btnToggleSound);
        this.subButtons.add(new ESMButton(0, this.btnToggleSound.field_146128_h + 12, this.field_146129_i, 10, 10, "", () -> soundHandler.func_147682_a((ISound)new PlayButtonSound(this.sound))).setIcon(Icon.PLAY));
    }

    public ESMButton getBtnToggleSound() {
        return this.btnToggleSound;
    }

    private void toggleSound() {
        if (this.muffled) {
            if (MainScreen.isMain()) {
                muffledSounds.remove(this.sound);
            } else {
                this.anchor.removeSound(this.sound);
            }
            this.setMuffled(false);
        } else {
            boolean didMuffle = false;
            if (MainScreen.isMain()) {
                this.setSliderValue(Config.getDefaultMuteVolume());
                muffledSounds.put(this.sound, Float.valueOf(this.sliderValue));
                didMuffle = true;
            } else if (this.anchor.getAnchorPos() != null) {
                this.setSliderValue(Config.getDefaultMuteVolume());
                this.anchor.addSound(this.sound, this.sliderValue);
                didMuffle = true;
            }
            this.setMuffled(didMuffle);
        }
    }

    private void changeSliderValue(float mouseX) {
        this.setSliderValue((mouseX - (float)(this.field_146128_h + 4)) / (float)(this.field_146120_f - 8));
    }

    private void setSliderValue(float value) {
        this.sliderValue = MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f);
        this.setTickSound(this.sliderValue);
        if (this.sliderValue == 1.0f) {
            this.toggleSound();
        } else {
            this.updateVolume();
        }
    }

    protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        if (this.isDragging && showSlider) {
            if (!this.muffled && this.canMuffle()) {
                this.toggleSound();
            }
            this.changeSliderValue(mouseX);
        }
        super.func_146119_b(mc, mouseX, mouseY);
    }

    @Override
    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (!this.isVisible() || !this.field_146124_l) {
            return false;
        }
        for (ESMButton button : this.subButtons) {
            if (!button.isMouseOver(mouseX, mouseY)) continue;
            button.func_146116_c(mc, mouseX, mouseY);
        }
        if (this.isMouseOver(mouseX, mouseY)) {
            this.isDragging = true;
            showSlider = true;
            return true;
        }
        return false;
    }

    public void func_146118_a(int mouseX, int mouseY) {
        if (!this.isVisible() || !this.field_146124_l) {
            return;
        }
        for (ESMButton button : this.subButtons) {
            if (!button.isMouseOver(mouseX, mouseY)) continue;
            button.func_146118_a(mouseX, mouseY);
        }
        this.isDragging = false;
        MuffledSlider.stopTickSound();
        super.func_146118_a(mouseX, mouseY);
    }

    public static void stopTickSound() {
        if (tickSound != null) {
            tickSound.finishPlaying();
            tickSound = null;
        }
    }

    public void setTickSound(float volume) {
        SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
        if (volume == 1.0f || !this.muffled) {
            MuffledSlider.stopTickSound();
            return;
        }
        if (tickSound == null) {
            tickSound = new SliderSound(this.sound);
            soundHandler.func_147682_a((ISound)tickSound);
        }
        tickSound.setVolume(volume);
    }

    private void updateVolume() {
        if (MainScreen.isMain()) {
            muffledSounds.replace(this.sound, Float.valueOf(this.sliderValue));
        } else {
            Objects.requireNonNull(MainScreen.getCurrentAnchor()).replaceSound(this.sound, this.sliderValue);
        }
    }

    public MuffledSlider setMuffled(boolean muffled) {
        this.muffled = muffled;
        return this;
    }

    private boolean canMuffle() {
        return MainScreen.isMain() || this.anchor.getAnchorPos() != null;
    }

    static {
        showSlider = false;
    }
}

