/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.utils;

import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import java.util.Comparator;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.DimensionManager;

public class Anchor {
    private final int id;
    private String name;
    private int dimensionId;
    private int radius;
    private SortedMap<String, Float> muffledSounds = new TreeMap<String, Float>();
    private Vec3 anchorPos;

    public Anchor(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public Anchor(int id, String name, Vec3 anchorPos, int dimensionId, int radius, SortedMap<String, Float> muffledSounds) {
        this.id = id;
        this.name = name;
        this.anchorPos = anchorPos;
        this.dimensionId = dimensionId;
        this.radius = radius;
        this.muffledSounds = muffledSounds;
    }

    public Vec3 getAnchorPos() {
        return this.anchorPos;
    }

    private void setAnchorPos(int x, int y, int z) {
        this.anchorPos = Vec3.func_72443_a((double)x, (double)y, (double)z);
    }

    public int getAnchorId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int Radius) {
        this.radius = Radius;
    }

    private void setName(String name) {
        this.name = name;
    }

    public SortedMap<ResourceLocation, Float> getMuffledSounds() {
        TreeMap<ResourceLocation, Float> temp = new TreeMap<ResourceLocation, Float>(Comparator.comparing(ResourceLocation::toString));
        this.muffledSounds.forEach((R, F) -> temp.put(new ResourceLocation(R), (Float)F));
        return temp;
    }

    public void setMuffledSounds(SortedMap<ResourceLocation, Float> muffledSounds) {
        muffledSounds.forEach((R, F) -> this.muffledSounds.put(R.toString(), (Float)F));
    }

    public void addSound(ResourceLocation sound, float volume) {
        this.muffledSounds.put(sound.toString(), Float.valueOf(volume));
    }

    public void replaceSound(ResourceLocation sound, float volume) {
        this.muffledSounds.replace(sound.toString(), Float.valueOf(volume));
    }

    public int getX() {
        return this.anchorPos == null ? 0 : (int)this.anchorPos.field_72450_a;
    }

    public int getY() {
        return this.anchorPos == null ? 0 : (int)this.anchorPos.field_72448_b;
    }

    public int getZ() {
        return this.anchorPos == null ? 0 : (int)this.anchorPos.field_72449_c;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public String getDimensionName() {
        if (this.dimensionId == Integer.MIN_VALUE) {
            return "";
        }
        String name = DimensionManager.createProviderFor((int)this.dimensionId).func_80007_l();
        return name == null ? "???" : name;
    }

    private void setDimensionId(int id) {
        this.dimensionId = id;
    }

    public void removeSound(ResourceLocation sound) {
        this.muffledSounds.remove(sound.toString());
    }

    public void setAnchor() {
        EntityClientPlayerMP player = Objects.requireNonNull(Minecraft.func_71410_x().field_71439_g);
        this.setAnchorPos((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        this.setDimensionId(player.field_71093_bK);
        this.setRadius(this.getRadius() == 0 ? 32 : this.getRadius());
    }

    public void deleteAnchor() {
        this.setName("Anchor " + this.getAnchorId());
        this.anchorPos = null;
        this.setDimensionId(Integer.MIN_VALUE);
        this.setRadius(0);
        this.muffledSounds.clear();
    }

    public void editAnchor(String title, int Radius) {
        this.setName(title);
        this.setRadius(Radius);
    }

    public static Anchor getAnchor(ISound sound) {
        Vec3 soundPos = Vec3.func_72443_a((double)sound.func_147649_g(), (double)sound.func_147654_h(), (double)sound.func_147651_i());
        for (Anchor anchor : ISoundLists.anchorList) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (anchor.getAnchorPos() == null || world == null || world.field_73011_w.field_76574_g != anchor.getDimensionId() || !(soundPos.func_72438_d(anchor.getAnchorPos()) < (double)anchor.getRadius()) || !anchor.getMuffledSounds().containsKey(sound.func_147650_b())) continue;
            return anchor;
        }
        return null;
    }
}

