/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.leobeliik.extremesoundmuffler.Config;
import com.leobeliik.extremesoundmuffler.SoundMuffler;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.leobeliik.extremesoundmuffler.utils.Anchor;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.storage.ThreadedFileIOBase;
import org.apache.commons.io.FileUtils;

public class DataManager
implements ISoundLists {
    public static String identifier;
    private static final Gson gson;

    public static void loadData(String address) {
        identifier = DataManager.getIdentifier(address);
        DataManager.loadMuffledMap().forEach((R, F) -> muffledSounds.put(new ResourceLocation(R), F));
        if (!Config.getDisableAnchors()) {
            anchorList.clear();
            anchorList.addAll(DataManager.loadAnchors());
        }
    }

    public static void saveData() {
        DataManager.saveMuffledMap();
        if (!Config.getDisableAnchors()) {
            DataManager.saveAnchors();
        }
    }

    private static String getIdentifier(String address) {
        if (Minecraft.func_71410_x().func_71356_B()) {
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_71270_I();
        }
        int index = address.indexOf("/") + 1;
        return address.substring(index).replace(":", ".");
    }

    private static NBTTagCompound serializeAnchor(Anchor anchor) {
        NBTTagCompound anchorNBT = new NBTTagCompound();
        NBTTagCompound muffledNBT = new NBTTagCompound();
        anchorNBT.func_74768_a("ID", anchor.getAnchorId());
        anchorNBT.func_74778_a("NAME", anchor.getName());
        if (anchor.getAnchorPos() == null) {
            return anchorNBT;
        }
        anchorNBT.func_74768_a("X", (int)anchor.getAnchorPos().field_72450_a);
        anchorNBT.func_74768_a("Y", (int)anchor.getAnchorPos().field_72448_b);
        anchorNBT.func_74768_a("Z", (int)anchor.getAnchorPos().field_72449_c);
        anchorNBT.func_74768_a("DIM", anchor.getDimensionId());
        anchorNBT.func_74768_a("RAD", anchor.getRadius());
        anchor.getMuffledSounds().forEach((R, F) -> muffledNBT.func_74776_a(R.toString(), F.floatValue()));
        anchorNBT.func_74782_a("MUFFLED", (NBTBase)muffledNBT);
        return anchorNBT;
    }

    public static Anchor deserializeAnchor(NBTTagCompound nbt) {
        TreeMap<String, Float> muffledSounds = new TreeMap<String, Float>();
        NBTTagCompound muffledNBT = nbt.func_74775_l("MUFFLED");
        for (String key : muffledNBT.func_150296_c()) {
            muffledSounds.put(key, Float.valueOf(muffledNBT.func_74760_g(key)));
        }
        if (!(nbt.func_74764_b("X") && nbt.func_74764_b("Y") && nbt.func_74764_b("Z"))) {
            return new Anchor(nbt.func_74762_e("ID"), nbt.func_74779_i("NAME"));
        }
        return new Anchor(nbt.func_74762_e("ID"), nbt.func_74779_i("NAME"), Vec3.func_72443_a((double)nbt.func_74762_e("X"), (double)nbt.func_74762_e("Y"), (double)nbt.func_74762_e("Z")), nbt.func_74762_e("DIM"), nbt.func_74762_e("RAD"), muffledSounds);
    }

    private static void saveMuffledMap() {
        new File("ESM/").mkdir();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream("ESM/soundsMuffled.dat"), StandardCharsets.UTF_8);){
            writer.write(gson.toJson((Object)muffledSounds));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Map<String, Float> loadMuffledMap() {
        Map map;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream("ESM/soundsMuffled.dat"), StandardCharsets.UTF_8);
        try {
            map = (Map)gson.fromJson(new JsonReader((Reader)reader), new TypeToken<Map<String, Float>>(){}.getType());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonSyntaxException | IOException e) {
                return new HashMap<String, Float>();
            }
        }
        reader.close();
        return map;
    }

    private static void saveAnchors() {
        File file = new File("ESM/" + identifier, "anchor.dat");
        NBTTagCompound anchorsNBT = new NBTTagCompound();
        for (Anchor anchor : anchorList) {
            anchorsNBT.func_74782_a("Anchor" + anchor.getAnchorId(), (NBTBase)DataManager.serializeAnchor(anchor));
        }
        DataManager.writeNBT(file, anchorsNBT);
    }

    private static List<Anchor> loadAnchors() {
        File file = new File("ESM/" + identifier, "anchor.dat");
        NBTTagCompound anchorsNBT = DataManager.readNBT(file);
        if (anchorsNBT == null) {
            return IntStream.range(0, 10).mapToObj(i -> new Anchor(i, "Anchor " + i)).collect(Collectors.toList());
        }
        ArrayList<Anchor> temp = new ArrayList<Anchor>();
        for (int i2 = 0; i2 < anchorsNBT.func_150296_c().size(); ++i2) {
            temp.add(DataManager.deserializeAnchor(anchorsNBT.func_74775_l("Anchor" + i2)));
        }
        return temp;
    }

    public static void writeNBT(File file, NBTTagCompound tag) {
        ThreadedFileIOBase.field_75741_a.func_75735_a(() -> {
            try (FileOutputStream stream = FileUtils.openOutputStream((File)file);){
                CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)stream);
            }
            catch (Exception ex) {
                SoundMuffler.LOGGER.warn("Failed to save file: {}", new Object[]{file.getName(), ex});
            }
            return false;
        });
    }

    @Nullable
    public static NBTTagCompound readNBT(File file) {
        NBTTagCompound nBTTagCompound;
        block11: {
            if (!file.exists() || !file.isFile()) {
                return null;
            }
            FileInputStream stream = FileUtils.openInputStream((File)file);
            try {
                nBTTagCompound = CompressedStreamTools.func_74796_a((InputStream)stream);
                if (stream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    try {
                        return CompressedStreamTools.func_74797_a((File)file);
                    }
                    catch (Exception ex1) {
                        return null;
                    }
                }
            }
            ((InputStream)stream).close();
        }
        return nBTTagCompound;
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
    }
}

