/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities.energynet;

import com.brandon3055.brandonscore.common.utills.DataUtills;
import com.brandon3055.brandonscore.common.utills.ItemNBTHelper;
import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.handler.BalanceConfigHandler;
import com.brandon3055.draconicevolution.common.items.tools.Wrench;
import com.brandon3055.draconicevolution.common.tileentities.TileObjectSync;
import com.brandon3055.draconicevolution.common.tileentities.energynet.IRemoteEnergyHandler;
import com.brandon3055.draconicevolution.common.tileentities.energynet.LinkedEnergyDevice;
import com.brandon3055.draconicevolution.common.tileentities.energynet.TileEnergyRelay;
import com.brandon3055.draconicevolution.common.tileentities.energynet.TileEnergyTransceiver;
import com.brandon3055.draconicevolution.common.tileentities.energynet.TileWirelessEnergyTransceiver;
import com.brandon3055.draconicevolution.common.utills.EnergyStorage;
import com.brandon3055.draconicevolution.common.utills.LogHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileRemoteEnergyBase
extends TileObjectSync
implements IRemoteEnergyHandler {
    protected int powerTier;
    protected EnergyStorage storage = new EnergyStorage(0);
    public List<LinkedEnergyDevice> linkedDevices = new ArrayList<LinkedEnergyDevice>();
    protected int lastTickEnergy;
    private int tick = 0;
    public byte inView = 0;

    public void updateStorage() {
        this.storage.setCapacity(this.getCap());
        this.storage.setMaxExtract(this.getExt());
        this.storage.setMaxReceive(this.getRec());
    }

    public abstract int getCap();

    public abstract int getRec();

    public abstract int getExt();

    public void func_145845_h() {
        ++this.tick;
        this.updateLinkedDevices();
        if (this.linkedDevices.size() == 0) {
            this.detectAndSendChanges(-1);
        }
        if (this.field_145850_b.field_72995_K && this.inView > 0) {
            this.inView = (byte)(this.inView - 1);
        }
    }

    private void updateLinkedDevices() {
        for (LinkedEnergyDevice device : this.linkedDevices) {
            if (!device.isValid(this.field_145850_b)) {
                if (!this.field_145850_b.func_72938_d((int)device.xCoord, (int)device.zCoord).field_76636_d) continue;
                this.linkedDevices.remove(device);
                this.updateLinkedDevices();
                return;
            }
            IRemoteEnergyHandler remoteTile = device.getEnergyTile(this.field_145850_b);
            if (this.field_145850_b.field_72995_K) {
                int rType = 0;
                if (this instanceof TileEnergyRelay || this instanceof TileWirelessEnergyTransceiver) {
                    rType = remoteTile instanceof TileEnergyTransceiver ? 2 : 3;
                } else if (this instanceof TileEnergyTransceiver) {
                    rType = remoteTile instanceof TileEnergyRelay || remoteTile instanceof TileWirelessEnergyTransceiver ? 1 : 0;
                }
                device.beam = DraconicEvolution.proxy.energyBeam(this.field_145850_b, this.getBeamX(), this.getBeamY(), this.getBeamZ(), remoteTile.getBeamX(), remoteTile.getBeamY(), remoteTile.getBeamZ(), (int)device.energyFlow, this.getPowerTier() == 1, device.beam, true, rType);
                continue;
            }
            double difference = this.getCapacity() - remoteTile.getCapacity();
            double energyToEqual = Math.round(difference / 100.0 * (double)remoteTile.getStorage().getMaxEnergyStored() / 2.01);
            double maxFlow = Math.min(energyToEqual, (double)Math.min(this.storage.getMaxExtract(), remoteTile.getStorage().getMaxEnergyStored() - remoteTile.getStorage().getEnergyStored()));
            device.energyFlow = this.getFlow(this.getCapacity(), remoteTile.getCapacity());
            int flow = (int)(device.energyFlow / 100.0 * maxFlow);
            int transfered = this.storage.extractEnergy(remoteTile.getStorage().receiveEnergy(this.storage.extractEnergy(flow, true), false), false);
            device.energyFlow = Math.min((double)transfered / 10000.0 * 100.0, 100.0);
            this.detectAndSendChanges(this.linkedDevices.indexOf(device));
        }
    }

    protected void detectAndSendChanges(int index) {
        boolean forceSend;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean bl = forceSend = (this.tick + this.field_145851_c + this.field_145848_d + this.field_145849_e) % 100 == 0;
        if ((this.tick + this.field_145851_c + this.field_145848_d + this.field_145849_e) % 20 == 0 || forceSend) {
            if (index >= 0 && (this.linkedDevices.get((int)index).energyFlow != this.linkedDevices.get((int)index).lastTickEnergyFlow || forceSend)) {
                this.sendObjectToClient((byte)9, 0, new DataUtills.IntPair(index, (int)this.linkedDevices.get((int)index).energyFlow));
                this.linkedDevices.get((int)index).lastTickEnergyFlow = this.linkedDevices.get((int)index).energyFlow;
            }
            if (this.storage.getEnergyStored() != this.lastTickEnergy || forceSend) {
                this.sendObjectToClient((byte)2, 1, this.storage.getEnergyStored());
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void receiveObjectFromServer(int index, Object object) {
        if (index == 0 && object instanceof DataUtills.IntPair && this.linkedDevices.size() > ((DataUtills.IntPair)object).i1) {
            this.linkedDevices.get((int)((DataUtills.IntPair)object).i1).energyFlow = ((DataUtills.IntPair)object).i2;
        } else if (index == 1) {
            this.storage.setEnergyStored((Integer)object);
        }
    }

    @Override
    public double getCapacity() {
        return (double)this.storage.getEnergyStored() / (double)this.storage.getMaxEnergyStored() * 100.0;
    }

    public double getFlow(double localCap, double remoteCap) {
        return Math.max(0.0, Math.min(100.0, (localCap - remoteCap) * 10.0));
    }

    public int getPowerTier() {
        return this.powerTier;
    }

    public void onBlockActivated(EntityPlayer player) {
        ItemStack wrench = player.func_70694_bm();
        if (wrench != null && wrench.func_77973_b() == Items.field_151055_y) {
            for (LinkedEnergyDevice ld : this.linkedDevices) {
                if (ld.beam == null) continue;
                LogHelper.info(ld.beam.getFlow());
            }
        }
        if (wrench == null || wrench.func_77973_b() != ModItems.wrench) {
            return;
        }
        String mode = Wrench.getMode(wrench);
        NBTTagCompound linkDat = null;
        if (wrench.func_77942_o() && wrench.func_77978_p().func_74764_b("LinkData")) {
            linkDat = wrench.func_77978_p().func_74775_l("LinkData");
        }
        if (mode.equals("bind")) {
            if (linkDat != null && linkDat.func_74764_b("Bound") && linkDat.func_74767_n("Bound")) {
                this.handleBinding(player, linkDat.func_74762_e("XCoord"), linkDat.func_74762_e("YCoord"), linkDat.func_74762_e("ZCoord"), true);
                linkDat.func_74757_a("Bound", false);
            } else {
                linkDat = new NBTTagCompound();
                linkDat.func_74768_a("XCoord", this.field_145851_c);
                linkDat.func_74768_a("YCoord", this.field_145848_d);
                linkDat.func_74768_a("ZCoord", this.field_145849_e);
                linkDat.func_74757_a("Bound", true);
                ItemNBTHelper.getCompound((ItemStack)wrench).func_74782_a("LinkData", (NBTBase)linkDat);
                if (this.field_145850_b.field_72995_K) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("msg.de.posSaved.txt", new Object[0]));
                }
            }
        } else if (mode.equals("unBind")) {
            if (linkDat != null && linkDat.func_74764_b("Bound") && linkDat.func_74767_n("Bound")) {
                for (LinkedEnergyDevice ld : this.linkedDevices) {
                    if (ld.xCoord != linkDat.func_74762_e("XCoord") || ld.yCoord != linkDat.func_74762_e("YCoord") || ld.zCoord != linkDat.func_74762_e("ZCoord")) continue;
                    if (!(ld.getTile(this.field_145850_b) instanceof TileRemoteEnergyBase)) {
                        LogHelper.error("TileRemoteEnergyBase - UNBIND - Remote tile invalid (This should be reported)");
                        break;
                    }
                    for (LinkedEnergyDevice rld : ((TileRemoteEnergyBase)ld.getTile((World)this.field_145850_b)).linkedDevices) {
                        if (rld.xCoord != this.field_145851_c || rld.yCoord != this.field_145848_d || rld.zCoord != this.field_145849_e) continue;
                        ((TileRemoteEnergyBase)ld.getTile((World)this.field_145850_b)).linkedDevices.remove(rld);
                        break;
                    }
                    this.linkedDevices.remove(ld);
                    break;
                }
                linkDat.func_74757_a("Bound", false);
            } else {
                linkDat = new NBTTagCompound();
                linkDat.func_74768_a("XCoord", this.field_145851_c);
                linkDat.func_74768_a("YCoord", this.field_145848_d);
                linkDat.func_74768_a("ZCoord", this.field_145849_e);
                linkDat.func_74757_a("Bound", true);
                ItemNBTHelper.getCompound((ItemStack)wrench).func_74782_a("LinkData", (NBTBase)linkDat);
                if (this.field_145850_b.field_72995_K) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("msg.de.posSaved.txt", new Object[0]));
                }
            }
        } else if (mode.equals("unBindAll")) {
            if (this instanceof TileWirelessEnergyTransceiver) {
                ((TileWirelessEnergyTransceiver)this).receiverList.clear();
            }
            block3: for (LinkedEnergyDevice ld : this.linkedDevices) {
                if (!(ld.getTile(this.field_145850_b) instanceof TileRemoteEnergyBase)) {
                    LogHelper.error("TileRemoteEnergyBase - UNBIND - Remote tile invalid (This should be reported)");
                    break;
                }
                for (LinkedEnergyDevice rld : ((TileRemoteEnergyBase)ld.getTile((World)this.field_145850_b)).linkedDevices) {
                    if (rld.xCoord != this.field_145851_c || rld.yCoord != this.field_145848_d || rld.zCoord != this.field_145849_e) continue;
                    ((TileRemoteEnergyBase)ld.getTile((World)this.field_145850_b)).linkedDevices.remove(rld);
                    continue block3;
                }
            }
            this.linkedDevices.clear();
        } else {
            this.handleOther(player, wrench);
        }
    }

    @Override
    public boolean handleBinding(EntityPlayer player, int x, int y, int z, boolean callOther) {
        IRemoteEnergyHandler tile;
        int range = this.powerTier == 0 ? BalanceConfigHandler.energyDeviceBasicLinkingRange : BalanceConfigHandler.energyDeviceAdvancedLinkingRange;
        IRemoteEnergyHandler iRemoteEnergyHandler = tile = this.field_145850_b.func_147438_o(x, y, z) instanceof IRemoteEnergyHandler ? (IRemoteEnergyHandler)this.field_145850_b.func_147438_o(x, y, z) : null;
        if (tile == null || x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e) {
            if (this.field_145850_b.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("msg.de.invalidTile.txt", new Object[0]));
            }
            return false;
        }
        if (Utills.getDistanceAtoB((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)x, (double)y, (double)z) > (double)range) {
            if (this.field_145850_b.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("msg.de.outOfRange.txt", new Object[0]));
            }
            return false;
        }
        if (this.linkedDevices.size() >= this.getMaxConnections()) {
            if (this.field_145850_b.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("msg.de.maxConnections.txt", new Object[0]));
            }
            return false;
        }
        if (callOther && !tile.handleBinding(player, this.field_145851_c, this.field_145848_d, this.field_145849_e, false)) {
            return false;
        }
        if (callOther && this.field_145850_b.field_72995_K) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("msg.de.linked.txt", new Object[0]));
        }
        for (LinkedEnergyDevice ld : this.linkedDevices) {
            if (ld.xCoord != x || ld.yCoord != y || ld.zCoord != z) continue;
            return true;
        }
        this.linkedDevices.add(new LinkedEnergyDevice(x, y, z));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public boolean handleOther(EntityPlayer player, ItemStack wrench) {
        return false;
    }

    @Override
    public EnergyStorage getStorage() {
        return this.storage;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return false;
    }

    public void func_145841_b(NBTTagCompound compound) {
        compound.func_74774_a("Type", (byte)this.powerTier);
        int index = 0;
        compound.func_74768_a("LinkCount", this.linkedDevices.size());
        for (LinkedEnergyDevice ld : this.linkedDevices) {
            ld.writeToNBT(compound, "LinkedDevice_" + index);
            ++index;
        }
        super.func_145841_b(compound);
        this.storage.writeToNBT(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.powerTier = compound.func_74771_c("Type");
        this.updateStorage();
        int linkCount = compound.func_74762_e("LinkCount");
        this.linkedDevices = new ArrayList<LinkedEnergyDevice>();
        for (int i = 0; i < linkCount; ++i) {
            this.linkedDevices.add(new LinkedEnergyDevice().readFromNBT(compound, "LinkedDevice_" + i));
        }
        super.func_145839_a(compound);
        this.storage.readFromNBT(compound);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }
}

