/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.TMultiPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mrtjp.core.color.Colors;
import mrtjp.core.color.Colors$;
import mrtjp.core.fx.FXEngine$;
import mrtjp.core.fx.ParticleAction;
import mrtjp.core.fx.ParticleAction$;
import mrtjp.core.fx.particles.BeamMulti;
import mrtjp.core.fx.particles.CoreParticle;
import mrtjp.core.fx.particles.SpriteParticle;
import mrtjp.projectred.core.Configurator$;
import mrtjp.projectred.core.TAcquisitionsCommons;
import mrtjp.projectred.core.libmc.PRLib$;
import mrtjp.projectred.transportation.BeamPathFinder$;
import mrtjp.projectred.transportation.TNetworkPipe;
import mrtjp.projectred.transportation.TransportationSPH$;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;

public final class RouteFX2$ {
    public static final RouteFX2$ MODULE$;
    private final int color_receive;
    private final int color_send;
    private final int color_relay;
    private final int color_routeLost;
    private final int color_route;
    private final int color_sync;
    private final int color_request;
    private final int color_checkInv;
    private final int color_linked;
    private final int color_unlinked;
    private final int color_blink;

    static {
        new RouteFX2$();
    }

    public int color_receive() {
        return this.color_receive;
    }

    public int color_send() {
        return this.color_send;
    }

    public int color_relay() {
        return this.color_relay;
    }

    public int color_routeLost() {
        return this.color_routeLost;
    }

    public int color_route() {
        return this.color_route;
    }

    public int color_sync() {
        return this.color_sync;
    }

    public int color_request() {
        return this.color_request;
    }

    public int color_checkInv() {
        return this.color_checkInv;
    }

    public int color_linked() {
        return this.color_linked;
    }

    public int color_unlinked() {
        return this.color_unlinked;
    }

    public int color_blink() {
        return this.color_blink;
    }

    public boolean isFXDisabled() {
        return !Configurator$.MODULE$.pipeRoutingFX();
    }

    public void spawnType1(int colour, TNetworkPipe pipe) {
        if (((TMultiPart)pipe).world().field_72995_K) {
            this.spawnType1_do(colour, pipe);
        } else {
            this.sendPacket(((TMultiPart)pipe).world(), ((TAcquisitionsCommons)((Object)pipe)).posOfInternal(), 1, colour, -1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnType1_do(int colour, TNetworkPipe pipe) {
        if (this.isFXDisabled()) {
            return;
        }
        Colors.Color c1 = Colors$.MODULE$.BLACK();
        Colors.Color c2 = (Colors.Color)Colors$.MODULE$.apply(colour);
        SpriteParticle particle = new SpriteParticle(((TMultiPart)pipe).world());
        FXEngine$.MODULE$.addEffect((CoreParticle)particle);
        particle.setPos(((TAcquisitionsCommons)((Object)pipe)).posOfInternal().toVector3Centered());
        particle.setMaxAge(15);
        particle.texture_$eq("projectred:textures/particles/large_colourless_bubble.png");
        particle.alpha_$eq(0.0);
        particle.setRGB((double)c1.rF(), (double)c1.gF(), (double)c1.bF());
        particle.scale_$eq(Vector3.zero.copy());
        ParticleAction act = ParticleAction$.MODULE$.sequence((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParticleAction[]{ParticleAction$.MODULE$.group((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParticleAction[]{ParticleAction$.MODULE$.scaleFor(0.085, 0.085, 0.085, 5.0), ParticleAction$.MODULE$.fadeIn(2.5), ParticleAction$.MODULE$.changeColourTo((double)c2.rF(), (double)c2.gF(), (double)c2.bF(), 5.0)})), ParticleAction$.MODULE$.delay(5.0), ParticleAction$.MODULE$.group((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParticleAction[]{ParticleAction$.MODULE$.scaleFor(0.085, 0.085, 0.085, 5.0), ParticleAction$.MODULE$.fadeOut(2.5), ParticleAction$.MODULE$.changeColourTo((double)c1.rF(), (double)c1.gF(), (double)c1.bF(), 5.0)})), ParticleAction$.MODULE$.kill()}));
        particle.runAction(act);
    }

    public void spawnType2(int colour, int dir, TNetworkPipe pipe) {
        if (((TMultiPart)pipe).world().field_72995_K) {
            this.spawnType2_do(colour, dir, pipe);
        } else {
            this.sendPacket(((TMultiPart)pipe).world(), ((TAcquisitionsCommons)((Object)pipe)).posOfInternal(), 2, colour, dir);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnType2_do(int colour, int dir, TNetworkPipe pipe) {
        if (this.isFXDisabled()) {
            return;
        }
        Colors.Color c1 = Colors$.MODULE$.BLACK();
        Colors.Color c2 = (Colors.Color)Colors$.MODULE$.apply(colour);
        BeamMulti beam = new BeamMulti(((TMultiPart)pipe).world());
        FXEngine$.MODULE$.addEffect((CoreParticle)beam);
        beam.setMaxAge(15);
        beam.texture_$eq("projectred:textures/particles/beam4.png");
        beam.points_$eq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector3[]{((TAcquisitionsCommons)((Object)pipe)).posOfInternal().toVector3Centered(), ((TAcquisitionsCommons)((Object)pipe)).posOfInternal().offset(dir).toVector3Centered()})));
        beam.alpha_$eq(0.0);
        beam.setRGB((double)c1.rF(), (double)c1.gF(), (double)c1.bF());
        ParticleAction act = ParticleAction$.MODULE$.sequence((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParticleAction[]{ParticleAction$.MODULE$.group((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParticleAction[]{ParticleAction$.MODULE$.changeColourTo((double)c2.rF(), (double)c2.gF(), (double)c2.bF(), 5.0), ParticleAction$.MODULE$.fadeIn(2.5)})), ParticleAction$.MODULE$.delay(5.0), ParticleAction$.MODULE$.group((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParticleAction[]{ParticleAction$.MODULE$.changeColourTo((double)c1.rF(), (double)c1.gF(), (double)c1.bF(), 5.0), ParticleAction$.MODULE$.fadeOut(2.5)})), ParticleAction$.MODULE$.kill()}));
        beam.runAction(act);
    }

    public void spawnType3(int colour, int dir, TNetworkPipe pipe) {
        if (((TMultiPart)pipe).world().field_72995_K) {
            this.spawnType3_do(colour, dir, pipe);
        } else {
            this.sendPacket(((TMultiPart)pipe).world(), ((TAcquisitionsCommons)((Object)pipe)).posOfInternal(), 3, colour, dir);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnType3_do(int colour, int dir, TNetworkPipe pipe) {
        if (this.isFXDisabled()) {
            return;
        }
        Set<Seq<Vector3>> paths = BeamPathFinder$.MODULE$.findPaths(pipe, dir);
        Colors.Color c1 = Colors$.MODULE$.BLACK();
        Colors.Color c2 = (Colors.Color)Colors$.MODULE$.apply(colour);
        ParticleAction act = ParticleAction$.MODULE$.sequence((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParticleAction[]{ParticleAction$.MODULE$.group((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParticleAction[]{ParticleAction$.MODULE$.changeColourTo((double)c2.rF(), (double)c2.gF(), (double)c2.bF(), 5.0), ParticleAction$.MODULE$.fadeIn(2.5)})), ParticleAction$.MODULE$.delay(5.0), ParticleAction$.MODULE$.group((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParticleAction[]{ParticleAction$.MODULE$.changeColourTo((double)c1.rF(), (double)c1.gF(), (double)c1.bF(), 5.0), ParticleAction$.MODULE$.fadeOut(2.5)})), ParticleAction$.MODULE$.kill()}));
        paths.foreach((Function1)new Serializable(pipe, c1, act){
            public static final long serialVersionUID = 0L;
            private final TNetworkPipe pipe$1;
            private final Colors.Color c1$1;
            private final ParticleAction act$1;

            public final void apply(Seq<Vector3> path) {
                if (path.size() > 1) {
                    BeamMulti beam = new BeamMulti(((TMultiPart)this.pipe$1).world());
                    FXEngine$.MODULE$.addEffect((CoreParticle)beam);
                    beam.setMaxAge(20);
                    beam.texture_$eq("projectred:textures/particles/beam4.png");
                    beam.points_$eq(path);
                    beam.alpha_$eq(0.0);
                    beam.setRGB((double)this.c1$1.rF(), (double)this.c1$1.gF(), (double)this.c1$1.bF());
                    beam.runAction(this.act$1);
                }
            }
            {
                this.pipe$1 = pipe$1;
                this.c1$1 = c1$1;
                this.act$1 = act$1;
            }
        });
    }

    public void sendPacket(World w, BlockCoord bc, int id, int colour, int dir) {
        PacketCustom packet = new PacketCustom((Object)TransportationSPH$.MODULE$.channel(), TransportationSPH$.MODULE$.particle_Spawn());
        packet.writeByte(id);
        packet.writeByte(colour).writeCoord(bc);
        Object object = dir != -1 ? packet.writeByte(dir) : BoxedUnit.UNIT;
        packet.sendPacketToAllAround((double)bc.x, (double)bc.y, (double)bc.z, 64.0, w.field_73011_w.field_76574_g);
    }

    public void handleClientPacket(MCDataInput in, World w) {
        short id = in.readUByte();
        short colour = in.readUByte();
        TMultiPart tMultiPart = PRLib$.MODULE$.getMultiPart((IBlockAccess)w, in.readCoord(), 6);
        if (tMultiPart instanceof TNetworkPipe) {
            BoxedUnit boxedUnit;
            TNetworkPipe tNetworkPipe = (TNetworkPipe)tMultiPart;
            short s = id;
            switch (s) {
                default: {
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 3: {
                    this.spawnType3_do(colour, in.readUByte(), tNetworkPipe);
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 2: {
                    this.spawnType2_do(colour, in.readUByte(), tNetworkPipe);
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 1: {
                    this.spawnType1_do(colour, tNetworkPipe);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private RouteFX2$() {
        MODULE$ = this;
        this.color_receive = Colors$.MODULE$.ORANGE().ordinal();
        this.color_send = Colors$.MODULE$.PURPLE().ordinal();
        this.color_relay = Colors$.MODULE$.CYAN().ordinal();
        this.color_routeLost = Colors$.MODULE$.MAGENTA().ordinal();
        this.color_route = Colors$.MODULE$.RED().ordinal();
        this.color_sync = Colors$.MODULE$.LIGHT_BLUE().ordinal();
        this.color_request = Colors$.MODULE$.PINK().ordinal();
        this.color_checkInv = Colors$.MODULE$.WHITE().ordinal();
        this.color_linked = Colors$.MODULE$.LIME().ordinal();
        this.color_unlinked = Colors$.MODULE$.RED().ordinal();
        this.color_blink = Colors$.MODULE$.LIGHT_GREY().ordinal();
    }
}

