/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.blaze;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.EffectHelper;
import toast.specialMobs.MobHelper;
import toast.specialMobs.Properties;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.SpecialMobData;
import toast.specialMobs.entity.blaze.Entity_SpecialBlaze;

public class EntityConflagrationBlaze
extends Entity_SpecialBlaze {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "blaze/conflagration.png")};
    private byte feedingLevel;

    public EntityConflagrationBlaze(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
        this.field_70728_aV += 4;
        this.BLAZE_SNOWBALL_HITS = Properties.getDouble("_mob_stats", "conflagration_snowball_hits");
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (!(damageSource.func_76347_k() || damageSource.func_94541_c() || damageSource.func_82725_o() || DamageSource.field_76369_e.field_76373_n.equals(damageSource.field_76373_n) || damageSource.func_76364_f() instanceof EntitySnowball)) {
            damage = Math.min(MobHelper.isCritical(damageSource) ? this.func_110138_aP() / 10.0f : this.func_110138_aP() / 20.0f, damage);
            if (damageSource.func_76352_a()) {
                damage /= 2.0f;
            }
            damage = Math.max(damage, MobHelper.isCritical(damageSource) ? 1.0f : 0.5f);
            if (!this.field_70170_p.field_72995_K && this.feedingLevel < 7) {
                this.setFeedingLevel(this.feedingLevel + 1, true);
                SpecialMobData data = this.getSpecialData();
                data.addAttribute(SharedMonsterAttributes.field_111264_e, 1.0);
                data.arrowDamage += 0.5f;
                data.arrowRefireMin = (short)(data.arrowRefireMin - 4);
                data.arrowRefireMax = (short)(data.arrowRefireMax - 4);
                if (this.feedingLevel == 7) {
                    this.fireballBurstCount = (short)(this.fireballBurstCount + 1);
                }
            }
        }
        return super.func_70097_a(damageSource, damage);
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        if (hit) {
            int i = this.field_70146_Z.nextInt(3 + looting);
            while (i-- > 0) {
                this.func_145779_a(Items.field_151059_bz, 1);
            }
            if (this.field_70146_Z.nextInt(5) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0) {
                ItemStack itemStack = new ItemStack((Item)Items.field_151068_bn, 1, 8195);
                EffectHelper.addPotionEffect(itemStack, Potion.field_76426_n, 600, 0);
                this.func_70099_a(itemStack, 0.0f);
            }
        }
    }

    protected void func_70600_l(int superRare) {
        ItemStack drop = new ItemStack(Items.field_151041_m);
        EffectHelper.setItemName(drop, "Pyre", 13);
        drop.func_77966_a(Enchantment.field_77334_n, 10);
        drop.func_77966_a(Enchantment.field_77347_r, 6);
        this.func_70099_a(drop, 0.0f);
    }

    private void setFeedingLevel(int level, boolean updateScale) {
        if (level < 0) {
            level = 0;
        } else if (level > 7) {
            level = 7;
        }
        int diff = level - this.feedingLevel;
        if (diff != 0) {
            this.feedingLevel = (byte)level;
            this.func_70105_a(0.8f + 0.01429f * (float)level, 1.8f + 0.12857f * (float)level);
            if (updateScale) {
                this.getSpecialData().setRenderScale(this.getSpecialData().getRenderScale() + 0.1f * (float)diff);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74774_a("FeedLevel", this.feedingLevel);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("FeedLevel")) {
            this.setFeedingLevel(tag.func_74771_c("FeedLevel"), false);
        }
    }
}

