/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IProvide;
import logisticspipes.interfaces.routing.IProvideFluids;
import logisticspipes.request.IExtraPromise;
import logisticspipes.request.IPromise;
import logisticspipes.request.resources.FluidResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.item.ItemIdentifier;

public class FluidLogisticsPromise
implements IPromise {
    private final FluidIdentifier liquid;
    private final int amount;
    private final IProvideFluids sender;
    private final IOrderInfoProvider.ResourceType type;

    public FluidLogisticsPromise(FluidIdentifier liquid, int amount, IProvideFluids sender, IOrderInfoProvider.ResourceType type) {
        this.liquid = liquid;
        this.amount = amount;
        this.sender = sender;
        this.type = type;
    }

    @Override
    public FluidLogisticsPromise copy() {
        return new FluidLogisticsPromise(this.liquid, this.amount, this.sender, this.type);
    }

    @Override
    public boolean matches(IResource requestType) {
        if (requestType instanceof FluidResource) {
            FluidResource fluid = (FluidResource)requestType;
            return fluid.getFluid().equals(this.liquid);
        }
        return false;
    }

    @Override
    public IExtraPromise split(int more) {
        throw new UnsupportedOperationException("Fluid Promises can't be split");
    }

    @Override
    public IProvide getProvider() {
        return this.sender;
    }

    @Override
    public ItemIdentifier getItemType() {
        return this.liquid.getItemIdentifier();
    }

    @Override
    public IOrderInfoProvider fullFill(IResource requestType, IAdditionalTargetInformation info) {
        return this.sender.fullFill(this, ((FluidResource)requestType).getTarget(), this.type, info);
    }

    public FluidIdentifier getLiquid() {
        return this.liquid;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public IOrderInfoProvider.ResourceType getType() {
        return this.type;
    }
}

