/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.api.message;

import chylex.hee.api.message.MessageHandler;
import chylex.hee.api.message.MessageRunner;
import chylex.hee.api.message.element.base.Precondition;
import chylex.hee.api.message.element.base.PreconditionComposite;
import chylex.hee.api.message.utils.MessageLogger;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public final class MessagePattern {
    private final PreconditionComposite<?> conditions = PreconditionComposite.noValue();
    private final MessageHandler handler;

    MessagePattern(MessageHandler handler) {
        this.handler = handler;
    }

    public MessagePattern addProp(String name, Precondition condition) {
        this.conditions.addCondition(name, condition);
        return this;
    }

    boolean tryRun(NBTTagCompound root) {
        if (!this.conditions.checkType((NBTBase)root)) {
            MessageLogger.logError("Unexpected message format, expected NBTTagCompound, got $0 || $1", root.getClass().getSimpleName(), root);
            return false;
        }
        if (!this.conditions.checkValue((NBTBase)root)) {
            return false;
        }
        this.handler.call(new MessageRunner(this.conditions, root));
        return true;
    }
}

