/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.boss.dragon.managers;

import chylex.hee.entity.boss.EntityBossDragon;
import chylex.hee.mechanics.causatum.CausatumMeters;
import chylex.hee.mechanics.causatum.CausatumUtils;
import chylex.hee.system.achievements.AchievementEvents;
import chylex.hee.system.achievements.AchievementManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;

public class DragonAchievementManager {
    private final EntityBossDragon dragon;
    private final Map<UUID, AchievementData> playerData;
    private int battleTimer;
    private byte playerCheck;

    public DragonAchievementManager(EntityBossDragon dragon) {
        this.dragon = dragon;
        this.playerData = new HashMap<UUID, AchievementData>();
    }

    public void updateManager() {
        this.playerCheck = (byte)(this.playerCheck + 1);
        if (this.playerCheck > 100) {
            this.playerCheck = 0;
            ++this.battleTimer;
            for (EntityPlayer player : this.dragon.field_70170_p.field_73010_i) {
                if (player.field_71075_bZ.field_75098_d) continue;
                AchievementData data = this.getData(player.func_110124_au());
                data.participationCounter = (short)(data.participationCounter + 1);
            }
        }
    }

    private AchievementData getData(UUID id) {
        AchievementData data = this.playerData.get(id);
        if (data == null) {
            data = new AchievementData();
            this.playerData.put(id, data);
        }
        return data;
    }

    public void onPlayerDied(EntityPlayer player) {
        this.getData(player.func_110124_au()).deathAmount = (short)(this.getData(player.func_110124_au()).deathAmount + 1);
    }

    public void onPlayerKilledEnderman(EntityPlayer player) {
        this.getData(player.func_110124_au()).killedEnderman = true;
    }

    public void onBattleFinished() {
        if (this.battleTimer < 24) {
            return;
        }
        int finalDiff = this.dragon.rewards.getFinalDifficultyRaw();
        for (Map.Entry<UUID, AchievementData> entry : this.playerData.entrySet()) {
            if ((float)entry.getValue().participationCounter / (float)this.battleTimer < 0.75f) continue;
            CausatumUtils.increase(entry.getKey(), CausatumMeters.DRAGON_KILL_PARTICIPATION, 300.0f);
            if (finalDiff < 68) continue;
            EntityPlayer player = this.dragon.field_70170_p.func_152378_a(entry.getKey());
            if (entry.getValue().deathAmount == 0 && finalDiff >= 98) {
                if (player == null) {
                    AchievementEvents.addDelayedAchievement(entry.getKey(), AchievementManager.CHALLENGE_HARD0DEATHS);
                } else {
                    player.func_71064_a((StatBase)AchievementManager.CHALLENGE_HARD0DEATHS, 1);
                }
            }
            if (entry.getValue().killedEnderman) continue;
            if (player == null) {
                AchievementEvents.addDelayedAchievement(entry.getKey(), AchievementManager.CHALLENGE_NOENDERMAN);
                continue;
            }
            player.func_71064_a((StatBase)AchievementManager.CHALLENGE_NOENDERMAN, 1);
        }
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        for (Map.Entry<UUID, AchievementData> entry : this.playerData.entrySet()) {
            tag.func_74782_a(entry.getKey().toString(), (NBTBase)entry.getValue().writeToNBT());
        }
        tag.func_74768_a("___timer", this.battleTimer);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        for (String key : tag.func_150296_c()) {
            NBTBase b = tag.func_74781_a(key);
            if (!(b instanceof NBTTagCompound)) continue;
            NBTTagCompound compound = (NBTTagCompound)b;
            this.getData(UUID.fromString(key)).readFromNBT(compound);
        }
        this.battleTimer = tag.func_74762_e("___timer");
    }

    class AchievementData {
        private short participationCounter;
        private short deathAmount;
        private boolean killedEnderman;

        AchievementData() {
        }

        private final NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74777_a("participationCnt", this.participationCounter);
            tag.func_74777_a("deathAmount", this.deathAmount);
            tag.func_74757_a("killedEnderman", this.killedEnderman);
            return tag;
        }

        private final void readFromNBT(NBTTagCompound tag) {
            this.participationCounter = tag.func_74765_d("participationCnt");
            this.deathAmount = tag.func_74765_d("deathAmount");
            this.killedEnderman = tag.func_74767_n("killedEnderman");
        }
    }
}

