/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.item;

import chylex.hee.entity.GlobalMobData;
import chylex.hee.entity.projectile.EntityProjectileSacredWand;
import chylex.hee.item.ItemAbstractEnergyAcceptor;
import chylex.hee.mechanics.enhancements.EnhancementHandler;
import chylex.hee.mechanics.enhancements.types.SacredWandEnhancements;
import chylex.hee.mechanics.wand.WandCore;
import chylex.hee.mechanics.wand.WandType;
import chylex.hee.system.util.CollectionUtil;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.ItemUtil;
import chylex.hee.system.util.MathUtil;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemSacredWand
extends ItemAbstractEnergyAcceptor {
    public static boolean attackEntity(ItemStack is, EntityPlayer player, EntityLivingBase entity, EntityProjectileSacredWand projectile) {
        List<WandCore> cores;
        List<Enum> enhancements;
        boolean hasCapability;
        int knockback;
        NBTTagCompound nbt = ItemUtil.getTagRoot(is, true);
        float damage = WandType.fromItemStack((ItemStack)is).baseDamage;
        if (GlobalMobData.isEnderGooTolerant(entity)) {
            damage *= 1.5f;
        } else if (entity instanceof IMob) {
            damage *= 1.2f;
        }
        boolean critical = false;
        boolean magic = false;
        boolean isMelee = projectile == null;
        EntityLivingBase[] attacked = new EntityLivingBase[]{entity};
        int n = knockback = isMelee && player.func_70051_ag() ? 2 : 0;
        if (entity.field_70170_p.func_82737_E() - nbt.func_74763_f("latktm") >= 600L) {
            damage *= 1.2f;
            nbt.func_74772_a("latktm", entity.field_70170_p.func_82737_E());
            critical = true;
        }
        if (hasCapability = (enhancements = EnhancementHandler.getEnhancements(is)).contains(SacredWandEnhancements.CAPABILITY)) {
            damage *= 1.1f;
        }
        if ((cores = WandCore.getCores(is)).contains((Object)WandCore.DEXTERITY)) {
            int max = hasCapability ? 3 : 2;
            ArrayList<EntityLivingBase> newAttacked = CollectionUtil.newList(max + 1, new EntityLivingBase[]{entity});
            List<EntityLiving> closest = DragonUtil.getClosestEntities(max, (Entity)entity, entity.field_70170_p.func_72872_a(EntityLiving.class, entity.field_70121_D.func_72314_b(4.0, 4.0, 4.0)));
            for (EntityLiving e : closest) {
                double d = e.func_70032_d((Entity)entity);
                double d2 = enhancements.contains(SacredWandEnhancements.RANGE) ? 4.0 : 2.5;
                if (!(d <= d2)) continue;
                newAttacked.add((EntityLivingBase)e);
            }
            attacked = newAttacked.toArray(new EntityLivingBase[newAttacked.size()]);
        }
        if (cores.contains((Object)WandCore.FORCE)) {
            damage *= 1.2f;
        }
        if (cores.contains((Object)WandCore.REPULSION)) {
            knockback += isMelee ? 1 + MathUtil.floor(Math.max(0.0, 6.0 - (double)player.func_70032_d((Entity)entity) * 0.75)) : 4;
        }
        if (isMelee && is.func_77960_j() == is.func_77958_k()) {
            damage *= 0.1f;
        }
        boolean didHurt = false;
        for (EntityLivingBase target : attacked) {
            if (target.func_70097_a((DamageSource)(isMelee ? DamageSource.func_76365_a((EntityPlayer)player) : new EntityDamageSourceIndirect("player", (Entity)projectile, (Entity)player)), magic ? damage * 0.8f : damage)) {
                if (knockback > 0) {
                    double motX = isMelee ? (double)(-MathHelper.func_76126_a((float)MathUtil.toRad(player.field_70177_z))) : projectile.field_70159_w;
                    double motZ = isMelee ? (double)MathHelper.func_76134_b((float)MathUtil.toRad(player.field_70177_z)) : projectile.field_70179_y;
                    target.func_70024_g(motX * (double)knockback * 0.25, 0.1, motZ * (double)knockback * 0.25);
                    if (isMelee) {
                        player.field_70159_w *= 0.6;
                        player.field_70179_y *= 0.6;
                        player.func_70031_b(false);
                    }
                }
                if (critical) {
                    player.func_71009_b((Entity)target);
                }
                player.func_130011_c((Entity)target);
                EnchantmentHelper.func_151385_b((EntityLivingBase)player, (Entity)target);
                player.func_71064_a(StatList.field_75951_w, Math.round(damage * 10.0f));
                didHurt = true;
            }
            if (magic) {
                target.field_70172_ad = 0;
                target.func_70097_a(DamageSource.field_76376_m, damage * 0.2f);
            }
            target.field_70172_ad = target.field_70172_ad * 3 / 4;
        }
        return didHurt;
    }

    public int getMaxDamage(ItemStack is) {
        return this.calculateMaxDamage(is, SacredWandEnhancements.CAPACITY);
    }

    @Override
    public boolean canAcceptEnergy(ItemStack is) {
        return is.func_77960_j() > 0;
    }

    @Override
    public void onEnergyAccepted(ItemStack is) {
        is.func_77964_b(is.func_77960_j() - 7);
    }

    @Override
    public int getEnergyPerUse(ItemStack is) {
        return EnhancementHandler.hasEnhancement(is, SacredWandEnhancements.EFFICIENCY) ? 2 : 3;
    }

    @Override
    protected float getRegenSpeedMultiplier() {
        return 0.02f;
    }

    public boolean func_77644_a(ItemStack is, EntityLivingBase entity, EntityLivingBase attacker) {
        this.damageItem(is, attacker);
        return true;
    }

    public boolean onLeftClickEntity(ItemStack is, EntityPlayer player, Entity entity) {
        if (!(entity instanceof EntityLivingBase)) {
            return false;
        }
        if (!entity.func_70075_an() || entity.func_85031_j((Entity)player)) {
            return true;
        }
        if (ItemSacredWand.attackEntity(is, player, (EntityLivingBase)entity, null)) {
            this.damageItem(is, (EntityLivingBase)player);
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer player) {
        if (is.func_77960_j() == is.func_77958_k()) {
            return is;
        }
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)new EntityProjectileSacredWand(world, (EntityLivingBase)player, is));
        }
        this.damageItem(is, (EntityLivingBase)player);
        return is;
    }

    public Multimap getAttributeModifiers(ItemStack is) {
        Multimap map = super.getAttributeModifiers(is);
        map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 0.0, 0));
        return map;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }
}

