/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.compendium.events;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.gui.ContainerEndPowderEnhancements;
import chylex.hee.gui.GuiEnderCompendium;
import chylex.hee.mechanics.compendium.KnowledgeRegistrations;
import chylex.hee.mechanics.compendium.content.KnowledgeObject;
import chylex.hee.mechanics.compendium.events.CompendiumEvents;
import chylex.hee.mechanics.compendium.objects.IKnowledgeObjectInstance;
import chylex.hee.mechanics.compendium.player.PlayerCompendiumData;
import chylex.hee.mechanics.compendium.util.KnowledgeUtils;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.server.S03SimpleEvent;
import chylex.hee.proxy.ModClientProxy;
import chylex.hee.proxy.ModCommonProxy;
import chylex.hee.system.achievements.AchievementManager;
import chylex.hee.system.logging.Stopwatch;
import chylex.hee.system.util.ReflectionUtils;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.stats.Achievement;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public final class CompendiumEventsClient {
    private static CompendiumEventsClient instance;
    private final KeyBinding keyOpenCompendium;
    private PlayerCompendiumData data;
    private short newlyDiscoveredId = (short)-1;
    private long newlyDiscoveredTime = 0L;
    private byte achievementTimer = (byte)-128;

    public static CompendiumEventsClient getInstance() {
        return instance;
    }

    public static void register() {
        if (instance == null) {
            instance = new CompendiumEventsClient();
            FMLCommonHandler.instance().bus().register((Object)instance);
        }
    }

    public static void loadClientData(PlayerCompendiumData data) {
        CompendiumEventsClient.instance.data = data;
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiEnderCompendium) {
            ((GuiEnderCompendium)Minecraft.func_71410_x().field_71462_r).updateCompendiumData(data);
        }
        if (Minecraft.func_71410_x().field_71439_g.field_71070_bA instanceof ContainerEndPowderEnhancements) {
            ((ContainerEndPowderEnhancements)Minecraft.func_71410_x().field_71439_g.field_71070_bA).updateClientItems();
        }
    }

    public static PlayerCompendiumData getClientData() {
        return CompendiumEventsClient.instance.data;
    }

    public static boolean canOpenCompendium() {
        if (CompendiumEventsClient.instance.data == null) {
            Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(I18n.func_135052_a((String)"compendium.dataError", (Object[])new Object[0])));
            return false;
        }
        return true;
    }

    public static void openCompendium(KnowledgeObject<? extends IKnowledgeObjectInstance<?>> obj, GuiScreen prevScreen) {
        GuiEnderCompendium compendium = new GuiEnderCompendium(CompendiumEventsClient.instance.data, prevScreen);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)compendium);
        if (obj != null) {
            compendium.showObject(obj);
            compendium.moveToCurrentObject(false);
        } else if (!CompendiumEventsClient.instance.data.seenHelp()) {
            compendium.showObject(KnowledgeRegistrations.HELP);
        }
    }

    public static int getCompendiumKeyCode() {
        return CompendiumEventsClient.instance.keyOpenCompendium.func_151463_i();
    }

    public static void onObjectDiscovered(int objectID) {
        CompendiumEventsClient.instance.newlyDiscoveredId = (short)objectID;
        CompendiumEventsClient.instance.newlyDiscoveredTime = System.nanoTime();
    }

    public static void showCompendiumAchievement() {
        instance.displayAchievement(AchievementManager.ENDER_COMPENDIUM);
    }

    public static void showVoidChestAchievement() {
        ModClientProxy.modifyVoidChestDescription = true;
        instance.displayAchievement(AchievementManager.VOID_CHEST);
        ModClientProxy.modifyVoidChestDescription = false;
    }

    private CompendiumEventsClient() {
        this.keyOpenCompendium = new KeyBinding(ModCommonProxy.hardcoreEnderbacon ? "key.openCompendium.bacon" : "key.openCompendium", 25, "Hardcore Ender Expansion");
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyOpenCompendium);
        Minecraft.func_71410_x().field_71474_y.func_74300_a();
    }

    private void displayAchievement(Achievement achievement) {
        Minecraft.func_71410_x().field_71458_u.func_146255_b(achievement);
        CompendiumEventsClient.instance.achievementTimer = (byte)120;
    }

    public boolean isKeybindingValid() {
        return this.keyOpenCompendium != null && this.keyOpenCompendium.func_151463_i() != 0;
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        Stopwatch.time("CompendiumEventsClient - key conflict check");
        for (KeyBinding kb : Minecraft.func_71410_x().field_71474_y.field_74324_K) {
            if (!this.isKeybindingValid() || kb == CompendiumEventsClient.instance.keyOpenCompendium || kb.func_151463_i() != CompendiumEventsClient.instance.keyOpenCompendium.func_151463_i()) continue;
            HardcoreEnderExpansion.notifications.report(I18n.func_135052_a((String)"key.openCompendium.conflict", (Object[])new Object[0]).replace("$", I18n.func_135052_a((String)kb.func_151464_g(), (Object[])new Object[0])));
            break;
        }
        Stopwatch.finish("CompendiumEventsClient - key conflict check");
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (this.achievementTimer > -128 && (this.achievementTimer = (byte)(this.achievementTimer - 1)) == -128) {
            Minecraft.func_71410_x().field_71458_u.func_146257_b();
        }
        if (this.isKeybindingValid() && (this.keyOpenCompendium.func_151468_f() || Keyboard.getEventKeyState() && Keyboard.getEventKey() == this.keyOpenCompendium.func_151463_i()) && (mc.field_71415_G || mc.field_71462_r instanceof GuiContainer) && CompendiumEventsClient.canOpenCompendium()) {
            KnowledgeObject<IKnowledgeObjectInstance<Object>> obj = null;
            if (mc.field_71415_G) {
                if (this.newlyDiscoveredTime != 0L && System.nanoTime() - this.newlyDiscoveredTime <= 7000000000L) {
                    obj = KnowledgeObject.getObjectById(this.newlyDiscoveredId);
                    this.newlyDiscoveredId = (short)-1;
                    this.newlyDiscoveredTime = 0L;
                } else {
                    obj = CompendiumEvents.getObservation((EntityPlayer)mc.field_71439_g).getObject();
                }
            } else {
                GuiContainer container = (GuiContainer)mc.field_71462_r;
                List slots = container.field_147002_h.field_75151_b;
                ScaledResolution res = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
                int mouseX = Mouse.getX() * res.func_78326_a() / mc.field_71443_c;
                int mouseY = res.func_78328_b() - Mouse.getY() * res.func_78328_b() / mc.field_71440_d - 1;
                int xSize = (Integer)ReflectionUtils.getFieldValue(container, "xSize");
                int ySize = (Integer)ReflectionUtils.getFieldValue(container, "ySize");
                mouseX -= (container.field_146294_l - xSize) / 2;
                mouseY -= (container.field_146295_m - ySize) / 2;
                for (Slot slot : slots) {
                    if (!slot.func_75216_d() || !slot.func_111238_b() || mouseX < slot.field_75223_e - 1 || mouseX > slot.field_75223_e + 16 || mouseY < slot.field_75221_f - 1 || mouseY > slot.field_75221_f + 16) continue;
                    obj = KnowledgeUtils.tryGetFromItemStack(slot.func_75211_c());
                    break;
                }
                if (obj == null) {
                    return;
                }
            }
            CompendiumEventsClient.openCompendium(obj, mc.field_71462_r);
            if (!mc.field_71439_g.func_146107_m().func_77443_a((Achievement)AchievementManager.ENDER_COMPENDIUM)) {
                PacketPipeline.sendToServer(new S03SimpleEvent(S03SimpleEvent.EventType.OPEN_COMPENDIUM));
                this.achievementTimer = (byte)-128;
            }
        }
    }
}

