/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.wand;

import chylex.hee.system.logging.Log;
import chylex.hee.system.util.CollectionUtil;
import chylex.hee.system.util.ItemUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public enum WandCore {
    INFESTATION,
    BLAZE,
    MAGIC,
    DEXTERITY,
    FORCE,
    REPULSION;

    public static WandCore[] values;

    public static List<WandCore> getCores(ItemStack is) {
        if (!ItemUtil.getTagRoot(is, false).func_74764_b("wandcores")) {
            return CollectionUtil.newList(new WandCore[0]);
        }
        NBTTagList list = is.func_77978_p().func_150295_c("wandcores", 8);
        ArrayList<WandCore> cores = new ArrayList<WandCore>(list.func_74745_c());
        for (int a = 0; a < list.func_74745_c(); ++a) {
            String data = list.func_150307_f(a);
            try {
                cores.add(data.isEmpty() ? null : Enum.valueOf(WandCore.class, data));
                continue;
            }
            catch (IllegalArgumentException e) {
                Log.error("Unknown wand core entry: " + data, new Object[0]);
            }
        }
        return cores;
    }

    public static boolean hasCore(ItemStack is, WandCore core) {
        if (!ItemUtil.getTagRoot(is, false).func_74764_b("wandcores")) {
            return false;
        }
        NBTTagList list = is.func_77978_p().func_150295_c("wandcores", 8);
        String name = core.name();
        for (int a = 0; a < list.func_74745_c(); ++a) {
            if (!list.func_150307_f(a).equals(name)) continue;
            return true;
        }
        return false;
    }

    public static void setCores(ItemStack is, WandCore[] cores) {
        NBTTagList list = new NBTTagList();
        for (WandCore core : cores) {
            list.func_74742_a((NBTBase)new NBTTagString(core == null ? "" : core.name()));
        }
        ItemUtil.getTagRoot(is, true).func_74782_a("wandcores", (NBTBase)list);
    }

    static {
        values = WandCore.values();
    }
}

