/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.logging;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.proxy.ModCommonProxy;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Calendar;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Log {
    static final Logger logger = LogManager.getLogger((String)"HardcoreEnderExpansion");
    public static final boolean isDeobfEnvironment;
    public static boolean forceDebugEnabled;
    private static FastDateFormat dateFormat;
    private static long lastLogReport;
    private static byte obfEnvironmentWarning;

    public static void initializeDebug() {
        if (forceDebugEnabled || isDeobfEnvironment) {
            HardcoreEnderExpansion.proxy.sendMessage(ModCommonProxy.MessageType.DEBUG_TITLE_SET, ArrayUtils.EMPTY_INT_ARRAY);
        }
        if (forceDebugEnabled) {
            HardcoreEnderExpansion.notifications.report("[Hardcore Ender Expansion] Forced debugging is enabled.", true);
        }
    }

    public static boolean isDebugEnabled() {
        return forceDebugEnabled || isDeobfEnvironment;
    }

    public static void debug(String message, Object ... data) {
        if (forceDebugEnabled || isDeobfEnvironment) {
            logger.info(Log.getMessage(message, data));
        }
        if (forceDebugEnabled && !isDeobfEnvironment && (obfEnvironmentWarning = (byte)(obfEnvironmentWarning + 1)) >= 30) {
            logger.warn(Log.getMessage("Detected obfuscated environment, don't forget to disable logging debug info after you are done debugging!", new Object[0]));
            obfEnvironmentWarning = 0;
        }
    }

    public static void reportedDebug(String message, Object ... data) {
        if (forceDebugEnabled || isDeobfEnvironment) {
            Log.debug(message, data);
            HardcoreEnderExpansion.notifications.report("[DEBUG] " + Log.getMessage(message, data));
        }
    }

    public static void info(String message, Object ... data) {
        logger.info(Log.getMessage(message, data));
    }

    public static void warn(String message, Object ... data) {
        logger.warn(Log.getMessage(message, data));
        if (forceDebugEnabled || isDeobfEnvironment) {
            HardcoreEnderExpansion.notifications.report("[WARN] " + Log.getMessage(message, data));
        }
    }

    public static void error(String message, Object ... data) {
        logger.error(Log.getMessage(message, data));
        if (forceDebugEnabled || isDeobfEnvironment) {
            HardcoreEnderExpansion.notifications.report("[ERROR] " + Log.getMessage(message, data));
        }
    }

    public static void reportedError(String message, Object ... data) {
        logger.error(Log.getMessage(message, data));
        HardcoreEnderExpansion.notifications.report("[" + dateFormat.format(Calendar.getInstance().getTime()) + "] " + Log.getMessage(message, data) + " Check the log for stack trace to report.");
    }

    public static void throwable(Throwable throwable, String message, Object ... data) {
        logger.catching(Level.ERROR, throwable);
        logger.error(Log.getMessage(message, data));
        if (lastLogReport == -1L || TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - lastLogReport) >= 10L) {
            HardcoreEnderExpansion.notifications.report("[" + dateFormat.format(Calendar.getInstance().getTime()) + "] " + Log.getMessage(message, data) + " Check the log for stack trace to report.");
        }
        lastLogReport = System.nanoTime();
    }

    private static String getMessage(String message, Object ... data) {
        for (int a = data.length - 1; a >= 0; --a) {
            message = message.replace("$" + a, data[a] == null ? "null" : String.valueOf(data[a]));
        }
        return message;
    }

    static {
        dateFormat = FastDateFormat.getInstance((String)"HH:mm:ss");
        lastLogReport = -1L;
        obfEnvironmentWarning = 0;
        isDeobfEnvironment = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        if (isDeobfEnvironment && MinecraftServer.func_71276_C() != null && MinecraftServer.func_71276_C().getClass().getSimpleName().equals("DedicatedServer")) {
            try (FileOutputStream fos = new FileOutputStream(new File("eula.txt"));){
                Properties properties = new Properties();
                properties.setProperty("eula", "true");
                properties.store(fos, "Screw your EULA, I don't want that stuff in my workspace.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

