/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.init.BlockList;
import chylex.hee.system.collections.WeightedList;
import chylex.hee.system.collections.weight.IWeightProvider;
import chylex.hee.system.commands.HeeDebugCommand;
import chylex.hee.system.logging.Stopwatch;
import chylex.hee.system.savedata.WorldDataHandler;
import chylex.hee.system.savedata.types.WorldGenSavefile;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.world.structure.ComponentLargeStructureWorld;
import chylex.hee.world.structure.island.biome.IslandBiomeBase;
import chylex.hee.world.structure.island.biome.data.BiomeContentVariation;
import chylex.hee.world.structure.island.biome.data.IslandBiomeData;
import chylex.hee.world.structure.island.gen.CaveGenerator;
import chylex.hee.world.structure.island.gen.OreGenerator;
import chylex.hee.world.structure.island.gen.TerrainGenerator;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class ComponentIsland
extends ComponentLargeStructureWorld {
    public static final int size = 208;
    public static final int halfSize = 104;
    private IslandBiomeBase biome;
    private IslandBiomeData biomeData;
    public static final HeeDebugCommand.HeeTest $debugTest = new HeeDebugCommand.HeeTest(){

        @Override
        public void run(String ... args) {
            int variation = args.length == 0 ? -1 : DragonUtil.tryParse(args[0], -1);
            for (IslandBiomeBase biome : new ArrayList<IslandBiomeBase>(IslandBiomeBase.biomeList)) {
                if (!biome.isValidMetadata(variation)) continue;
                ArrayList<IslandBiomeBase> prevBiomes = new ArrayList<IslandBiomeBase>(IslandBiomeBase.biomeList);
                IslandBiomeBase.biomeList.clear();
                IslandBiomeBase.biomeList.add(biome);
                try {
                    Field fieldVariations = IslandBiomeBase.class.getDeclaredField("contentVariations");
                    fieldVariations.setAccessible(true);
                    Object prevVariations = fieldVariations.get(biome);
                    BiomeContentVariation variationInst = null;
                    for (BiomeContentVariation var : (WeightedList)prevVariations) {
                        if (var.id != variation) continue;
                        variationInst = var;
                        break;
                    }
                    if (variationInst != null) {
                        fieldVariations.set(biome, new WeightedList((IWeightProvider[])new BiomeContentVariation[]{variationInst}));
                        this.generate();
                        fieldVariations.set(biome, prevVariations);
                        variation = -2;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    e.printStackTrace();
                }
                IslandBiomeBase.biomeList.clear();
                IslandBiomeBase.biomeList.addAll(prevBiomes);
            }
            if (variation == -1) {
                this.generate();
            }
        }

        private void generate() {
            ComponentIsland island = new ComponentIsland(this.world, this.world.field_73012_v, (int)this.player.field_70165_t - 104, (int)this.player.field_70161_v - 104);
            island.func_74875_a(this.world, this.world.field_73012_v, new StructureBoundingBox(-9999999, 0, -9999999, 9999999, 128, 9999999));
            HardcoreEnderExpansion.notifications.report("Generated island: " + island.biomeData.getDeviationsAsString(), true);
        }
    };

    public ComponentIsland() {
    }

    public ComponentIsland(World world, Random rand, int x, int z) {
        super(world, rand, x, 20, z, 208, 140, 208);
        this.field_74885_f = 0;
        this.field_74887_e = new StructureBoundingBox(x, 20, z, x + this.sizeX - 1, 140 + this.sizeY - 1, z + this.sizeZ - 1);
        ((WorldGenSavefile)WorldDataHandler.get(WorldGenSavefile.class)).addElementAt(this.getStartX() >> 4, this.getStartZ() >> 4, WorldGenSavefile.WorldGenElement.BIOME_ISLAND);
    }

    @Override
    protected int setupStructure(long seed) {
        int centerX = this.sizeX >> 1;
        int centerZ = this.sizeZ >> 1;
        Random consistentRand = new Random((long)(this.getStartX() / 9) * 238504L + (long)(this.getStartZ() / 9) * 10058432215L ^ seed);
        int islandBottomY = 6 + consistentRand.nextInt(25);
        this.biome = IslandBiomeBase.pickRandomBiome(consistentRand);
        this.biomeData = this.biome.generateData(consistentRand);
        this.biome.prepareDecoration(this.biomeData);
        float yMp = 0.66f * this.biome.getIslandMassHeightMultiplier();
        Stopwatch.time("ComponentIsland - total");
        Stopwatch.time("ComponentIsland - terrain");
        TerrainGenerator terrainGen = new TerrainGenerator(consistentRand, this.biome);
        for (int chunkX = 0; chunkX < 13; ++chunkX) {
            for (int chunkZ = 0; chunkZ < 13; ++chunkZ) {
                int blockStartX = chunkX * 16;
                int blockStartZ = chunkZ * 16;
                Block[] blocks = new Block[32768];
                terrainGen.generateTerrain(chunkX - 6, chunkZ - 6, blocks);
                for (int xInChunk = 0; xInChunk < 16; ++xInChunk) {
                    for (int zInChunk = 0; zInChunk < 16; ++zInChunk) {
                        int xx = blockStartX + xInChunk;
                        int zz = blockStartZ + zInChunk;
                        for (int yy = 0; yy < 128; ++yy) {
                            Block block = blocks[xInChunk << 11 | zInChunk << 7 | yy];
                            if (block == Blocks.field_150350_a) continue;
                            this.structure.setBlock(xx, (int)((float)yy * yMp), zz, block);
                        }
                        for (int y = this.structure.getHighestY(xx, zz); y >= 5; --y) {
                            if (this.structure.getBlock(xx, y, zz) != Blocks.field_150377_bs || !this.structure.isAir(xx, y + 1, zz)) continue;
                            this.structure.setBlock(xx, y, zz, IslandBiomeBase.getTopBlock(), this.biome.getTopBlockMeta());
                        }
                    }
                }
            }
        }
        Stopwatch.finish("ComponentIsland - terrain");
        Stopwatch.time("ComponentIsland - caves");
        CaveGenerator caveGen = new CaveGenerator(centerX, 28, centerZ, 96, 24, 96);
        caveGen.setup(consistentRand, this.biome);
        caveGen.generate(this.structure);
        Stopwatch.finish("ComponentIsland - caves");
        Stopwatch.time("ComponentIsland - ores");
        OreGenerator oreGen = new OreGenerator(8, 0, 8, 200, 55, 200);
        oreGen.setup(consistentRand, this.biome);
        oreGen.generate(this.structure, consistentRand);
        Stopwatch.finish("ComponentIsland - ores");
        Stopwatch.time("ComponentIsland - biome content " + this.biomeData.content.id);
        this.biome.decorateGen(this.structure, consistentRand, centerX, centerZ);
        Stopwatch.finish("ComponentIsland - biome content " + this.biomeData.content.id);
        this.structure.setBlock(104, 8, 104, BlockList.biome_core, this.biomeData.content.id, true);
        Stopwatch.finish("ComponentIsland - total");
        return islandBottomY;
    }
}

