/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.carpentry;

import binnie.core.util.I18N;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.api.ILayout;
import binnie.extratrees.carpentry.EnumDesignCategory;
import binnie.extratrees.carpentry.EnumPattern;
import binnie.extratrees.carpentry.Layout;

public enum EnumDesign implements IDesign
{
    Blank("blank"),
    Octagon("octagon"),
    Diamond("diamond"),
    Ringed("ringed"),
    Squared("squared"),
    Multiply("multiply"),
    Halved("halved"),
    Striped("striped"),
    ThinStriped("thinStriped"),
    Chequered("fullChequered"),
    Tiled("fullTiled"),
    ChequeredB("chequered"),
    TiledB("tiled"),
    VeryThinCorner("veryThinCornered"),
    ThinCorner("thinCornered"),
    Corner("cornered"),
    ThickCorner("thickCornered"),
    Edged("edged"),
    ThinEdged("thinEdged"),
    ThinBarred("thinBarred"),
    Barred("barred"),
    ThickBarred("thickBarred"),
    Diagonal("diagonal"),
    ThickDiagonal("thickDiagonal"),
    ThinSaltire("thinSaltire"),
    Saltire("saltire"),
    ThickSaltire("thickSaltire"),
    ThinCrossed("thinCrossed"),
    Crossed("crossed"),
    ThickCrossed("thickCrossed"),
    ThinTSection("thinTSection"),
    TSection("tSection"),
    ThickTSection("thickTSection"),
    ThinBarredCorner("thinBarredCorner"),
    BarredCorner("barredCorner"),
    ThickBarredCorner("thickBarredCorner"),
    ThinStripedCorner("thinStripedCorner"),
    StripedCorner("stripedCorner"),
    Emblem1("emblem1"),
    Emblem2("emblem2"),
    Emblem3("emblem3"),
    Emblem4("emblem4"),
    Emblem5("emblem5"),
    LetterA("letterA"),
    LetterB("letterB"),
    LetterC("letterC"),
    LetterD("letterD"),
    LetterE("letterE"),
    LetterF("letterF"),
    LetterG("letterG"),
    LetterH("letterH"),
    LetterI("letterI"),
    LetterJ("letterJ"),
    LetterK("letterK"),
    LetterL("letterL"),
    LetterM("letterM"),
    LetterN("letterN"),
    LetterO("letterO"),
    LetterP("letterP"),
    LetterQ("letterQ"),
    LetterR("letterR"),
    LetterS("letterS"),
    LetterT("letterT"),
    LetterU("letterU"),
    LetterV("letterV"),
    LetterW("letterW"),
    LetterX("letterX"),
    LetterY("letterY"),
    LetterZ("letterZ"),
    ThinCurvedCrossed("thinCurvedCrossed"),
    ThinCurvedBarredCorner("thinCurvedBarredCorner"),
    CurvedBarredCorner("curvedBarredCorner"),
    ThinCurvedCorner("thinCurvedCorner"),
    CurvedCorner("curvedCorner"),
    ThinCurvedTSection("thinCurvedTSection"),
    CurvedTSection("curvedTSection"),
    BarredEnd("barredEnd"),
    DiagonalCorner("diagonalCorner"),
    DiagonalTSection("diagonalTSection"),
    DiagonalCurvedCorner("diagonalCurvedCorner"),
    DiagonalCurvedTSection("diagonalCurvedTSection"),
    OrnateBarred("ornateBarred"),
    SplitBarred("splitBarred"),
    SplitBarredCorner("splitBarredCorner"),
    SplitBarredTSection("splitBarredTSection"),
    SplitCrossed("splitCrossed"),
    SplitBarredEnd("splitBarredEnd"),
    OrnateThinBarred("ornateThinBarred"),
    Circle("circle"),
    Plus("plus"),
    Creeper("creeper"),
    OrnateStripedCorner("ornateStripedCorner"),
    Test("testingBlock"),
    DiagonalHalved("diagonalHalved"),
    Diagonal1Edged("corneredDiagonal"),
    Diagonal2Edged("oppositeCorneredDiagonal"),
    ThickDiagonal1Edged("thickCorneredDiagonal"),
    ThinBarredEnd("thinBarredEnd"),
    ThickBarredEnd("thickBarredEnd"),
    OverlappedBarred("overlappedBarred"),
    OverlappedSplitBarred("overlappedSplitBarred");

    private String name;
    private ILayout topPattern;
    private ILayout bottomPattern;
    private ILayout northPattern;
    private ILayout southPattern;
    private ILayout eastPattern;
    private ILayout westPattern;

    private EnumDesign(String name) {
        this.name = name;
        this.topPattern = Layout.get(EnumPattern.Blank, false);
        this.bottomPattern = Layout.get(EnumPattern.Blank, false);
        this.northPattern = Layout.get(EnumPattern.Blank, false);
        this.eastPattern = Layout.get(EnumPattern.Blank, false);
        this.southPattern = Layout.get(EnumPattern.Blank, false);
        this.westPattern = Layout.get(EnumPattern.Blank, false);
    }

    void setEdgePatterns(ILayout north, ILayout east, ILayout south, ILayout west) {
        this.setNorthPattern(north);
        this.setEastPattern(east);
        this.setSouthPattern(south);
        this.setWestPattern(west);
    }

    void setEdgePatterns(ILayout face) {
        this.setEdgePatterns(face, face, face, face);
    }

    void setupStriped(ILayout vert) {
        this.setTopPattern(vert);
        this.setEdgePatterns(vert.invert(), EnumPattern.Blank.layout(true), vert, EnumPattern.Blank.layout());
    }

    void setChequered(ILayout cheq) {
        this.setAllPatterns(cheq);
        this.setNorthPattern(cheq.invert());
        this.setSouthPattern(cheq.invert());
        this.setBottomPattern(cheq.invert());
    }

    void setStripedChequered(ILayout cheq, ILayout stripe) {
        this.setAllPatterns(cheq);
        this.setNorthPattern(stripe.invert());
        this.setSouthPattern(stripe.invert());
        this.setEastPattern(stripe);
        this.setWestPattern(stripe);
    }

    void setCornered(ILayout corner, ILayout edge) {
        this.setTopPattern(corner);
        this.setNorthPattern(EnumPattern.Blank.layout());
        this.setEastPattern(edge.flipHorizontal());
        this.setSouthPattern(edge);
        this.setWestPattern(EnumPattern.Blank.layout());
    }

    void setEdged(ILayout edge) {
        this.setAllPatterns(edge);
        this.setWestPattern(EnumPattern.Blank.layout());
        this.setEastPattern(EnumPattern.Blank.layout(true));
        this.northPattern = this.northPattern.flipHorizontal();
    }

    void setBarred(ILayout bar) {
        this.setAllPatterns(bar);
        this.setEastPattern(EnumPattern.Blank.layout(true));
        this.setWestPattern(EnumPattern.Blank.layout(true));
    }

    void setDiagonal(ILayout diagonal, ILayout edged) {
        this.setAllPatterns(edged);
        this.setTopPattern(diagonal);
        this.northPattern = this.northPattern.flipHorizontal();
        this.southPattern = this.southPattern.flipHorizontal();
    }

    void setSaltire(ILayout saltire, ILayout bar) {
        this.setTopPattern(saltire);
        this.setEdgePatterns(bar.invert());
    }

    void setCross(ILayout saltire, ILayout bar) {
        this.setTopPattern(saltire);
        this.setEdgePatterns(bar);
    }

    void setTSection(ILayout tsection, ILayout bar) {
        this.setTopPattern(tsection);
        this.setEdgePatterns(bar);
        this.setWestPattern(EnumPattern.Blank.layout(true));
    }

    void setBarredCorner(ILayout corner, ILayout bar) {
        this.setTSection(corner, bar);
        this.setNorthPattern(EnumPattern.Blank.layout(true));
    }

    void setStripedCorner(ILayout corner, ILayout striped) {
        this.setCornered(corner, striped);
    }

    void setLetterPattern(ILayout letter) {
        this.setAllPatterns(EnumPattern.Blank.layout(true));
        this.setTopPattern(letter);
        this.setBottomPattern(EnumPattern.Blank.layout(true));
    }

    void setBarredEndPattern(ILayout end, ILayout bar) {
        this.setAllPatterns(EnumPattern.Blank.layout(true));
        this.setTopPattern(end);
        this.setWestPattern(bar);
    }

    void setDiagonalCorner(ILayout diagonal, ILayout bar, ILayout edged) {
        this.setAllPatterns(EnumPattern.Blank.layout(true));
        this.setTopPattern(diagonal);
        this.setWestPattern(bar.invert());
        this.setNorthPattern(edged.flipHorizontal());
        this.setSouthPattern(edged);
    }

    void setDiagonalTSection(ILayout diagonal, ILayout bar, ILayout edged) {
        this.setAllPatterns(EnumPattern.Blank.layout(true));
        this.setTopPattern(diagonal);
        this.setWestPattern(bar.invert());
        this.setNorthPattern(bar.invert());
        this.setEastPattern(edged.flipHorizontal());
        this.setSouthPattern(edged);
    }

    private void setAllPatterns(ILayout layout) {
        this.setTopPattern(layout);
        this.setBottomPattern(layout);
        this.setNorthPattern(layout);
        this.setEastPattern(layout);
        this.setSouthPattern(layout);
        this.setWestPattern(layout);
    }

    @Override
    public String getName() {
        return I18N.localise("botany.design." + this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ILayout getTopPattern() {
        return this.topPattern;
    }

    public void setTopPattern(ILayout layout) {
        this.topPattern = layout;
        this.setBottomPattern(layout);
    }

    @Override
    public ILayout getBottomPattern() {
        return this.bottomPattern;
    }

    public void setBottomPattern(ILayout layout) {
        this.bottomPattern = layout;
    }

    @Override
    public ILayout getNorthPattern() {
        return this.northPattern;
    }

    public void setNorthPattern(ILayout layout) {
        this.northPattern = layout;
    }

    @Override
    public ILayout getSouthPattern() {
        return this.southPattern;
    }

    public void setSouthPattern(ILayout layout) {
        this.southPattern = layout;
    }

    @Override
    public ILayout getEastPattern() {
        return this.eastPattern;
    }

    public void setEastPattern(ILayout layout) {
        this.eastPattern = layout;
    }

    @Override
    public ILayout getWestPattern() {
        return this.westPattern;
    }

    public void setWestPattern(ILayout layout) {
        this.westPattern = layout;
    }

    static {
        EnumDesignCategory.Design.addDesign(Blank);
        EnumDesignCategory.Design.addDesign(Octagon);
        EnumDesignCategory.Design.addDesign(Diamond);
        EnumDesignCategory.Design.addDesign(Ringed);
        EnumDesignCategory.Design.addDesign(Squared);
        EnumDesignCategory.Design.addDesign(Multiply);
        EnumDesignCategory.Design.addDesign(Plus);
        EnumDesignCategory.Design.addDesign(Circle);
        EnumDesignCategory.Design.addDesign(Emblem1);
        EnumDesignCategory.Design.addDesign(Emblem2);
        EnumDesignCategory.Design.addDesign(Emblem3);
        EnumDesignCategory.Design.addDesign(Emblem4);
        EnumDesignCategory.Design.addDesign(Emblem5);
        EnumDesignCategory.Design.addDesign(Creeper);
        EnumDesignCategory.Stripes.addDesign(Chequered);
        EnumDesignCategory.Stripes.addDesign(ChequeredB);
        EnumDesignCategory.Stripes.addDesign(Tiled);
        EnumDesignCategory.Stripes.addDesign(TiledB);
        EnumDesignCategory.Stripes.addDesign(Striped);
        EnumDesignCategory.Stripes.addDesign(ThinStriped);
        EnumDesignCategory.Stripes.addDesign(ThinStripedCorner);
        EnumDesignCategory.Stripes.addDesign(StripedCorner);
        EnumDesignCategory.Stripes.addDesign(OrnateStripedCorner);
        EnumDesignCategory.Edges.addDesign(Halved);
        EnumDesignCategory.Edges.addDesign(Corner);
        EnumDesignCategory.Edges.addDesign(ThickCorner);
        EnumDesignCategory.Edges.addDesign(Edged);
        EnumDesignCategory.Edges.addDesign(ThinCorner);
        EnumDesignCategory.Edges.addDesign(ThinEdged);
        EnumDesignCategory.Edges.addDesign(VeryThinCorner);
        EnumDesignCategory.Edges.addDesign(ThinCurvedCorner);
        EnumDesignCategory.Edges.addDesign(CurvedCorner);
        EnumDesignCategory.Barred.addDesign(ThinBarred);
        EnumDesignCategory.Barred.addDesign(ThinBarredCorner);
        EnumDesignCategory.Barred.addDesign(ThinTSection);
        EnumDesignCategory.Barred.addDesign(ThinCrossed);
        EnumDesignCategory.Barred.addDesign(ThinBarredEnd);
        EnumDesignCategory.Barred.addDesign(OrnateThinBarred);
        EnumDesignCategory.Barred.addDesign(Barred);
        EnumDesignCategory.Barred.addDesign(BarredCorner);
        EnumDesignCategory.Barred.addDesign(TSection);
        EnumDesignCategory.Barred.addDesign(Crossed);
        EnumDesignCategory.Barred.addDesign(BarredEnd);
        EnumDesignCategory.Barred.addDesign(OverlappedBarred);
        EnumDesignCategory.Barred.addDesign(OrnateBarred);
        EnumDesignCategory.Barred.addDesign(ThickBarred);
        EnumDesignCategory.Barred.addDesign(ThickBarredCorner);
        EnumDesignCategory.Barred.addDesign(ThickTSection);
        EnumDesignCategory.Barred.addDesign(ThickCrossed);
        EnumDesignCategory.Barred.addDesign(ThickBarredEnd);
        EnumDesignCategory.Barred.addDesign(ThinCurvedBarredCorner);
        EnumDesignCategory.Barred.addDesign(CurvedBarredCorner);
        EnumDesignCategory.Barred.addDesign(ThinCurvedTSection);
        EnumDesignCategory.Barred.addDesign(CurvedTSection);
        EnumDesignCategory.Barred.addDesign(ThinCurvedCrossed);
        EnumDesignCategory.Barred.addDesign(SplitBarred);
        EnumDesignCategory.Barred.addDesign(SplitBarredCorner);
        EnumDesignCategory.Barred.addDesign(SplitBarredTSection);
        EnumDesignCategory.Barred.addDesign(SplitCrossed);
        EnumDesignCategory.Barred.addDesign(SplitBarredEnd);
        EnumDesignCategory.Barred.addDesign(OverlappedSplitBarred);
        EnumDesignCategory.Diagonal.addDesign(ThinSaltire);
        EnumDesignCategory.Diagonal.addDesign(Diagonal);
        EnumDesignCategory.Diagonal.addDesign(DiagonalCorner);
        EnumDesignCategory.Diagonal.addDesign(DiagonalTSection);
        EnumDesignCategory.Diagonal.addDesign(DiagonalCurvedCorner);
        EnumDesignCategory.Diagonal.addDesign(DiagonalCurvedTSection);
        EnumDesignCategory.Diagonal.addDesign(Saltire);
        EnumDesignCategory.Diagonal.addDesign(ThickDiagonal);
        EnumDesignCategory.Diagonal.addDesign(ThickSaltire);
        EnumDesignCategory.Diagonal.addDesign(DiagonalHalved);
        EnumDesignCategory.Diagonal.addDesign(Diagonal1Edged);
        EnumDesignCategory.Diagonal.addDesign(Diagonal2Edged);
        EnumDesignCategory.Diagonal.addDesign(ThickDiagonal1Edged);
        Octagon.setAllPatterns(EnumPattern.Octagon.layout());
        Diamond.setAllPatterns(EnumPattern.Diamond.layout());
        Ringed.setAllPatterns(EnumPattern.Ringed.layout());
        Squared.setAllPatterns(EnumPattern.Squared.layout());
        Multiply.setAllPatterns(EnumPattern.Multiply.layout());
        ThinStriped.setupStriped(EnumPattern.ThinStriped.layout());
        Striped.setupStriped(EnumPattern.Striped.layout());
        Halved.setupStriped(EnumPattern.Halved.layout());
        Chequered.setChequered(EnumPattern.Chequered.layout());
        Tiled.setChequered(EnumPattern.Tiled.layout());
        ChequeredB.setStripedChequered(EnumPattern.Chequered.layout(), EnumPattern.Halved.layout());
        TiledB.setStripedChequered(EnumPattern.Tiled.layout(), EnumPattern.Striped.layout());
        VeryThinCorner.setCornered(EnumPattern.VeryThinCorner.layout(), EnumPattern.ThinEdged.layout());
        ThinCorner.setCornered(EnumPattern.ThinCorner.layout(), EnumPattern.Edged.layout());
        Corner.setCornered(EnumPattern.Corner.layout(), EnumPattern.Halved.layout());
        ThickCorner.setCornered(EnumPattern.ThickCorner.layout(), EnumPattern.Edged.layout(true).flipHorizontal());
        ThinCurvedCorner.setCornered(EnumPattern.ThinCurvedCorner.layout(), EnumPattern.Edged.layout());
        CurvedCorner.setCornered(EnumPattern.CurvedCorner.layout(), EnumPattern.Halved.layout());
        Edged.setEdged(EnumPattern.Edged.layout());
        ThinEdged.setEdged(EnumPattern.ThinEdged.layout());
        ThinBarred.setBarred(EnumPattern.ThinBarred.layout());
        Barred.setBarred(EnumPattern.Barred.layout());
        ThickBarred.setBarred(EnumPattern.ThickBarred.layout());
        Diagonal.setDiagonal(EnumPattern.Diagonal.layout(), EnumPattern.Edged.layout());
        ThickDiagonal.setDiagonal(EnumPattern.ThickDiagonal.layout(), EnumPattern.Halved.layout());
        ThinSaltire.setSaltire(EnumPattern.ThinSaltire.layout(), EnumPattern.ThickBarred.layout());
        Saltire.setSaltire(EnumPattern.Saltire.layout(), EnumPattern.Barred.layout());
        ThickSaltire.setSaltire(EnumPattern.ThickSaltire.layout(), EnumPattern.ThinBarred.layout());
        ThinCrossed.setCross(EnumPattern.ThinCrossed.layout(), EnumPattern.ThinBarred.layout());
        Crossed.setCross(EnumPattern.Crossed.layout(), EnumPattern.Barred.layout());
        ThickCrossed.setCross(EnumPattern.ThickCrossed.layout(), EnumPattern.ThickBarred.layout());
        ThinCurvedCrossed.setCross(EnumPattern.ThinCurvedCrossed.layout(), EnumPattern.ThinBarred.layout());
        ThinTSection.setTSection(EnumPattern.ThinTSection.layout(), EnumPattern.ThinBarred.layout());
        TSection.setTSection(EnumPattern.TSection.layout(), EnumPattern.Barred.layout());
        ThickTSection.setTSection(EnumPattern.ThickTSection.layout(), EnumPattern.ThickBarred.layout());
        ThinCurvedTSection.setTSection(EnumPattern.ThinCurvedTSection.layout(), EnumPattern.ThinBarred.layout());
        CurvedTSection.setTSection(EnumPattern.CurvedTSection.layout(), EnumPattern.Barred.layout());
        ThinBarredCorner.setBarredCorner(EnumPattern.ThinBarredCorner.layout(), EnumPattern.ThinBarred.layout());
        BarredCorner.setBarredCorner(EnumPattern.BarredCorner.layout(), EnumPattern.Barred.layout());
        ThickBarredCorner.setBarredCorner(EnumPattern.ThickBarredCorner.layout(), EnumPattern.ThickBarred.layout());
        ThinCurvedBarredCorner.setBarredCorner(EnumPattern.ThinCurvedBarredCorner.layout(), EnumPattern.ThinBarred.layout());
        CurvedBarredCorner.setBarredCorner(EnumPattern.BarredCurvedCorner.layout(), EnumPattern.Barred.layout());
        ThinStripedCorner.setStripedCorner(EnumPattern.ThinStripedCorner.layout(), EnumPattern.ThinStriped.layout());
        StripedCorner.setStripedCorner(EnumPattern.StripedCorner.layout(), EnumPattern.Striped.layout());
        OrnateStripedCorner.setStripedCorner(EnumPattern.OrnateStripedCorner.layout(), EnumPattern.ThinStriped.layout());
        Emblem1.setAllPatterns(EnumPattern.Emblem1.layout());
        Emblem2.setAllPatterns(EnumPattern.Emblem2.layout());
        Emblem3.setAllPatterns(EnumPattern.Emblem3.layout());
        Emblem4.setAllPatterns(EnumPattern.Emblem4.layout());
        Emblem5.setAllPatterns(EnumPattern.Emblem5.layout());
        LetterA.setLetterPattern(EnumPattern.LetterA.layout());
        LetterB.setLetterPattern(EnumPattern.LetterB.layout());
        LetterF.setLetterPattern(EnumPattern.LetterF.layout());
        LetterS.setLetterPattern(EnumPattern.LetterS.layout());
        LetterT.setLetterPattern(EnumPattern.LetterT.layout());
        BarredEnd.setBarredEndPattern(EnumPattern.BarredEnd.layout(), EnumPattern.Barred.layout());
        DiagonalCorner.setDiagonalCorner(EnumPattern.DiagonalCorner.layout(), EnumPattern.Barred.layout(), EnumPattern.Edged.layout());
        DiagonalTSection.setDiagonalTSection(EnumPattern.DiagonalTSection.layout(), EnumPattern.Barred.layout(), EnumPattern.Edged.layout());
        DiagonalCurvedCorner.setDiagonalCorner(EnumPattern.DiagonalCurvedCorner.layout(), EnumPattern.Barred.layout(), EnumPattern.Edged.layout());
        DiagonalCurvedTSection.setDiagonalTSection(EnumPattern.DiagonalCurvedTSection.layout(), EnumPattern.Barred.layout(), EnumPattern.Edged.layout());
        OrnateBarred.setBarred(EnumPattern.OrnateBarred.layout());
        OrnateThinBarred.setBarred(EnumPattern.OrnateThinBarred.layout());
        SplitBarred.setBarred(EnumPattern.SplitBarred.layout());
        SplitBarredCorner.setBarredCorner(EnumPattern.SplitBarredCorner.layout(), EnumPattern.SplitBarred.layout());
        SplitBarredTSection.setTSection(EnumPattern.SplitBarredTSection.layout(), EnumPattern.SplitBarred.layout());
        SplitCrossed.setCross(EnumPattern.SplitCrossed.layout(), EnumPattern.SplitBarred.layout());
        SplitBarredEnd.setBarredEndPattern(EnumPattern.SplitBarredEnd.layout(), EnumPattern.SplitBarred.layout());
        Circle.setAllPatterns(EnumPattern.Circle.layout());
        Plus.setAllPatterns(EnumPattern.Plus.layout());
        Creeper.setAllPatterns(EnumPattern.Blank.layout(true));
        Creeper.setTopPattern(EnumPattern.Creeper.layout());
        DiagonalHalved.setTopPattern(EnumPattern.DiagonalHalved.layout());
        DiagonalHalved.setEdgePatterns(EnumPattern.Blank.layout(), EnumPattern.Blank.layout(true), EnumPattern.Blank.layout(true), EnumPattern.Blank.layout());
        Diagonal1Edged.setTopPattern(EnumPattern.Diagonal1Edged.layout());
        Diagonal1Edged.setEdgePatterns(EnumPattern.Edged.layout().flipHorizontal(), EnumPattern.Blank.layout(true), EnumPattern.Blank.layout(true), EnumPattern.Edged.layout());
        Diagonal2Edged.setTopPattern(EnumPattern.Diagonal2Edged.layout());
        Diagonal2Edged.setEdgePatterns(EnumPattern.Edged.layout(), EnumPattern.Edged.layout().flipHorizontal(), EnumPattern.Edged.layout(), EnumPattern.Edged.layout().flipHorizontal());
        ThickDiagonal1Edged.setTopPattern(EnumPattern.ThickDiagonal1Edged.layout());
        ThickDiagonal1Edged.setEdgePatterns(EnumPattern.Halved.layout().flipHorizontal(), EnumPattern.Blank.layout(true), EnumPattern.Blank.layout(true), EnumPattern.Halved.layout());
        ThickBarredEnd.setBarredEndPattern(EnumPattern.ThickBarredEnd.layout(), EnumPattern.ThickBarred.layout());
        ThinBarredEnd.setBarredEndPattern(EnumPattern.ThinBarredEnd.layout(), EnumPattern.ThinBarred.layout());
        OverlappedSplitBarred.setAllPatterns(EnumPattern.SplitBarred.layout());
        OverlappedSplitBarred.setTopPattern(EnumPattern.OverlappedSplitBarred.layout());
        OverlappedBarred.setAllPatterns(EnumPattern.Barred.layout());
        OverlappedBarred.setTopPattern(EnumPattern.OverlappedBarred.layout());
    }
}

