/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.nei;

import binnie.core.nei.NEIUtils;
import binnie.core.nei.PositionedFluidTank;
import binnie.core.nei.RecipeHandlerBase;
import binnie.genetics.api.IIncubatorRecipe;
import binnie.genetics.machine.incubator.Incubator;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class IncubatorRecipeHandler
extends RecipeHandlerBase {
    public String getOverlayIdentifier() {
        return "genetics.incubator";
    }

    public String getGuiTexture() {
        return "genetics:textures/gui/nei/incubator.png";
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"genetics.machine.labMachine.incubator");
    }

    public void loadTransferRects() {
        this.addTransferRect(75, 27, 24, 17);
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)76);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(75, 27, 176, 0, 24, 17, 40, 0);
        GuiDraw.drawStringC((String)StatCollector.func_74838_a((String)"genetics.nei.tip.loss"), (int)62, (int)5, (int)0xFFFFFF);
        GuiDraw.drawStringC((String)((CachedIncubatorRecipe)((Object)this.arecipes.get((int)recipe))).lossChance, (int)62, (int)15, (int)0xFFFFFF);
    }

    @Override
    public void loadAllRecipes() {
        for (IIncubatorRecipe recipe : Incubator.RECIPES) {
            this.arecipes.add(new CachedIncubatorRecipe(recipe));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (IIncubatorRecipe recipe : Incubator.RECIPES) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getExpectedOutput(), (ItemStack)result)) continue;
            this.arecipes.add(new CachedIncubatorRecipe(recipe));
        }
    }

    @Override
    public void loadCraftingRecipes(FluidStack result) {
        for (IIncubatorRecipe recipe : Incubator.RECIPES) {
            if (!NEIUtils.areFluidsSameType(recipe.getOutput(), result)) continue;
            this.arecipes.add(new CachedIncubatorRecipe(recipe));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (IIncubatorRecipe recipe : Incubator.RECIPES) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getInputStack(), (ItemStack)ingredient)) continue;
            this.arecipes.add(new CachedIncubatorRecipe(recipe));
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        for (IIncubatorRecipe recipe : Incubator.RECIPES) {
            if (!NEIUtils.areFluidsSameType(recipe.getInput(), ingredient)) continue;
            this.arecipes.add(new CachedIncubatorRecipe(recipe));
        }
    }

    public class CachedIncubatorRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public List<PositionedFluidTank> tanks;
        public PositionedStack input;
        public PositionedStack output;
        public String lossChance;
        public String tickChance;

        public CachedIncubatorRecipe(IIncubatorRecipe recipe) {
            super(IncubatorRecipeHandler.this);
            this.tanks = new ArrayList<PositionedFluidTank>();
            if (recipe.getInput() != null) {
                FluidStack fluidStack = recipe.getInput();
                if (fluidStack.amount == 0) {
                    this.tanks.add(new PositionedFluidTank(new FluidStack(fluidStack.getFluid(), 1), 100, new Rectangle(28, 6, 16, 58)){

                        @Override
                        public List<String> handleTooltip(List<String> currenttip) {
                            List<String> tip = super.handleTooltip(currenttip);
                            tip.add(StatCollector.func_74838_a((String)"genetics.nei.tip.noConsume"));
                            return tip;
                        }
                    });
                } else {
                    this.tanks.add(new PositionedFluidTank(fluidStack, 100, new Rectangle(28, 6, 16, 58)));
                }
            }
            if (recipe.getOutput() != null) {
                this.tanks.add(new PositionedFluidTank(recipe.getOutput(), 100, new Rectangle(130, 6, 16, 58)));
            }
            if (recipe.getInputStack() != null) {
                this.input = new PositionedStack((Object)recipe.getInputStack(), 53, 27);
            }
            if (recipe.getExpectedOutput() != null) {
                this.output = new PositionedStack((Object)recipe.getExpectedOutput(), 105, 27);
            }
            this.lossChance = recipe.getLossChance() * 100.0f + "%";
        }

        @Override
        public List<PositionedFluidTank> getFluidTanks() {
            return this.tanks;
        }

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

