/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.nei;

import binnie.Binnie;
import binnie.botany.Botany;
import binnie.core.BinnieCore;
import binnie.core.Mods;
import binnie.core.genetics.Gene;
import binnie.core.nei.NEIUtils;
import binnie.core.nei.PositionedFluidTank;
import binnie.core.nei.PositionedStackAdv;
import binnie.core.nei.RecipeHandlerBase;
import binnie.genetics.Genetics;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.item.ItemSequence;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.ISpeciesRoot;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class IsolatorRecipeHandler
extends RecipeHandlerBase {
    private static final List<IsolatorRecipe> recipes = new ArrayList<IsolatorRecipe>();

    @Override
    public void prepare() {
        if (BinnieCore.isApicultureActive()) {
            recipes.add(new IsolatorRecipe(Mods.forestry.stack("beeDroneGE", 1, Short.MAX_VALUE)));
            recipes.add(new IsolatorRecipe(Mods.forestry.stack("beePrincessGE", 1, Short.MAX_VALUE)));
            recipes.add(new IsolatorRecipe(Mods.forestry.stack("beeQueenGE", 1, Short.MAX_VALUE)));
            recipes.add(new IsolatorRecipe(Mods.forestry.stack("beeLarvaeGE", 1, Short.MAX_VALUE)));
        }
        if (BinnieCore.isArboricultureActive()) {
            recipes.add(new IsolatorRecipe(Mods.forestry.stack("sapling", 1, Short.MAX_VALUE)));
            recipes.add(new IsolatorRecipe(Mods.forestry.stack("pollenFertile", 1, Short.MAX_VALUE)));
        }
        if (BinnieCore.isLepidopteryActive()) {
            recipes.add(new IsolatorRecipe(Mods.forestry.stack("butterflyGE", 1, Short.MAX_VALUE)));
            recipes.add(new IsolatorRecipe(Mods.forestry.stack("caterpillarGE", 1, Short.MAX_VALUE)));
            recipes.add(new IsolatorRecipe(Mods.forestry.stack("serumGE", 1, Short.MAX_VALUE)));
        }
        recipes.add(new IsolatorRecipe(new ItemStack((Item)Botany.flowerItem, 1, Short.MAX_VALUE)));
        recipes.add(new IsolatorRecipe(new ItemStack(Botany.seed, 1, Short.MAX_VALUE)));
        recipes.add(new IsolatorRecipe(new ItemStack(Botany.pollen, 1, Short.MAX_VALUE)));
    }

    public String getOverlayIdentifier() {
        return "genetics.isolator";
    }

    public String getGuiTexture() {
        return "genetics:textures/gui/nei/isolator.png";
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"genetics.machine.machine.isolator");
    }

    public void loadTransferRects() {
        this.addTransferRect(87, 27, 24, 17);
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)74);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(87, 27, 176, 0, 24, 17, 40, 0);
    }

    @Override
    public void loadAllRecipes() {
        for (IsolatorRecipe recipe : recipes) {
            this.arecipes.add(new CachedIsolatorRecipe(recipe));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        if (NEIServerUtils.areStacksSameTypeCrafting((ItemStack)new ItemStack(Genetics.itemSequencer), (ItemStack)result)) {
            for (IsolatorRecipe recipe : recipes) {
                this.arecipes.add(new CachedIsolatorRecipe(recipe));
            }
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        if (NEIUtils.areFluidsSameType(Binnie.Liquid.getLiquidStack("bioethanol", 0), ingredient)) {
            this.loadAllRecipes();
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        if (NEIServerUtils.areStacksSameTypeCrafting((ItemStack)GeneticsItems.EmptySequencer.get(1), (ItemStack)ingredient) || NEIServerUtils.areStacksSameTypeCrafting((ItemStack)GeneticsItems.Enzyme.get(1), (ItemStack)ingredient)) {
            this.loadAllRecipes();
        } else {
            for (IsolatorRecipe recipe : recipes) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getInput(), (ItemStack)ingredient)) continue;
                this.arecipes.add(new CachedIsolatorRecipe(recipe));
            }
        }
    }

    private static class IsolatorRecipe {
        private final ItemStack input;

        public IsolatorRecipe(ItemStack input) {
            this.input = input;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutputSequencer() {
            ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(this.input);
            IChromosomeType speciesChromosomeType = root.getKaryotypeKey();
            IAllele[] defaultTemplate = root.getDefaultTemplate();
            IAllele species = defaultTemplate[speciesChromosomeType.ordinal()];
            return ItemSequence.create(new Gene(species, speciesChromosomeType, root));
        }

        public FluidStack getEthanol() {
            return Binnie.Liquid.getLiquidStack("bioethanol", 10);
        }

        public ItemStack getEnzyme() {
            return GeneticsItems.Enzyme.get(1);
        }

        public ItemStack getEmptySequencer() {
            return GeneticsItems.EmptySequencer.get(1);
        }
    }

    public class CachedIsolatorRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedFluidTank ethanolTank;
        public PositionedStack emptySequencer;
        public PositionedStack input;
        public PositionedStack enzyme;
        public PositionedStack output;
        public List<PositionedStack> ingredients;

        public CachedIsolatorRecipe(IsolatorRecipe recipe) {
            super(IsolatorRecipeHandler.this);
            this.ingredients = new ArrayList<PositionedStack>();
            this.ethanolTank = new PositionedFluidTank(recipe.getEthanol(), 100, new Rectangle(40, 6, 16, 58));
            this.emptySequencer = new PositionedStack((Object)recipe.getEmptySequencer(), 65, 27);
            this.enzyme = new PositionedStack((Object)recipe.getEnzyme(), 65, 48);
            if (recipe.getInput() != null) {
                this.input = new PositionedStackAdv(recipe.getInput(), 65, 6).addToTooltip(StatCollector.func_74838_a((String)"genetics.nei.tip.loss") + " 5%");
                this.output = new PositionedStack((Object)recipe.getOutputSequencer(), 117, 27);
                this.ingredients.add(this.emptySequencer);
                this.ingredients.add(this.input);
                this.ingredients.add(this.enzyme);
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(IsolatorRecipeHandler.this.cycleticks / 40, this.ingredients);
        }

        public PositionedStack getResult() {
            this.output.setPermutationToRender(IsolatorRecipeHandler.this.cycleticks / 40 % this.output.items.length);
            return this.output;
        }

        @Override
        public PositionedFluidTank getFluidTank() {
            return this.ethanolTank;
        }
    }
}

