/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockSided;
import com.carpentersblocks.data.DaylightSensor;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.tileentity.TECarpentersDaylightSensor;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCarpentersDaylightSensor
extends BlockSided {
    private static DaylightSensor data = new DaylightSensor();

    public BlockCarpentersDaylightSensor(Material material) {
        super(material, data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        IconRegistry.icon_daylight_sensor_glass_top = iconRegister.func_94245_a("CarpentersBlocks:daylightsensor/daylight_sensor_glass_top");
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        int polarity = data.getPolarity(TE) == 0 ? 1 : 0;
        data.setPolarity(TE, polarity);
        this.notifyBlocksOfPowerChange(TE.func_145831_w(), TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
        if (polarity == 0) {
            ChatHandler.sendMessageToPlayer("message.polarity_pos.name", entityPlayer);
        } else {
            ChatHandler.sendMessageToPlayer("message.polarity_neg.name", entityPlayer);
        }
        return true;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        int sensitivity = data.setNextSensitivity(TE);
        this.notifyBlocksOfPowerChange(TE.func_145831_w(), TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
        switch (sensitivity) {
            case 0: {
                ChatHandler.sendMessageToPlayer("message.sensitivity_sleep.name", entityPlayer);
                break;
            }
            case 1: {
                ChatHandler.sendMessageToPlayer("message.sensitivity_monsters.name", entityPlayer);
                break;
            }
            case 2: {
                ChatHandler.sendMessageToPlayer("message.sensitivity_dynamic.name", entityPlayer);
            }
        }
        return true;
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.25f, data.getDirection(TE));
        }
    }

    @Override
    public int getPowerOutput(TEBase TE) {
        return data.getRedstoneOutput(TE);
    }

    public void updateLightLevel(World world, int x, int y, int z) {
        TEBase TE;
        if (!world.field_73011_w.field_76576_e && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            int temp = data.getLightLevel(TE);
            float angle = world.func_72929_e(1.0f);
            int lightValue = world.func_72972_b(EnumSkyBlock.Sky, x, y, z) - world.field_73008_k;
            int sensitivity = data.getSensitivity(TE);
            if (sensitivity == 2) {
                if ((double)angle <= 1.67 || (double)angle >= 4.62) {
                    switch (data.getDirection(TE)) {
                        case UP: {
                            lightValue = this.getCelestialRedstoneOutput(world, x, y, z, lightValue, angle);
                            break;
                        }
                        case NORTH: 
                        case SOUTH: {
                            lightValue = (int)((float)lightValue * 0.6f);
                            break;
                        }
                        case EAST: {
                            lightValue = this.getCelestialRedstoneOutput(world, x, y, z, lightValue, (float)((double)angle + 1.5707963267948966));
                            break;
                        }
                        case WEST: {
                            lightValue = this.getCelestialRedstoneOutput(world, x, y, z, lightValue, (float)((double)angle - 1.5707963267948966));
                            break;
                        }
                    }
                } else {
                    lightValue = 0;
                }
            } else if (sensitivity == 1 && world.func_72911_I()) {
                lightValue = 7;
            }
            if (temp != lightValue) {
                data.setLightLevel(TE, lightValue);
                this.notifyBlocksOfPowerChange(TE.func_145831_w(), TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
            }
        }
    }

    public int getCelestialRedstoneOutput(World world, int x, int y, int z, int skylight, float angle) {
        if (!world.field_73011_w.field_76576_e) {
            angle = angle < (float)Math.PI ? (angle += (0.0f - angle) * 0.2f) : (angle += ((float)Math.PI * 2 - angle) * 0.2f);
            skylight = Math.round((float)skylight * MathHelper.func_76134_b((float)angle));
            if (skylight < 0) {
                skylight = 0;
            } else if (skylight > 15) {
                skylight = 15;
            }
        }
        return skylight;
    }

    @Override
    public boolean canAttachToSide(int side) {
        return side != 0;
    }

    public boolean func_149744_f() {
        return true;
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TECarpentersDaylightSensor();
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersDaylightSensorRenderID;
    }
}

