/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.handler;

import com.carpentersblocks.api.ICarpentersChisel;
import com.carpentersblocks.api.ICarpentersHammer;
import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.network.PacketActivateBlock;
import com.carpentersblocks.network.PacketSlopeSelect;
import com.carpentersblocks.renderer.helper.ParticleHelper;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.handler.PacketHandler;
import com.carpentersblocks.util.handler.ShadersHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent17;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class EventHandler {
    public static float hitX;
    public static float hitY;
    public static float hitZ;
    public static int eventFace;
    public static PlayerInteractEvent IGNORE_INTERACT_EVENT;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpenEvent(GuiOpenEvent event) {
        if (event.gui == null && ShadersHandler.enableShadersModCoreIntegration) {
            ShadersHandler.update();
        }
    }

    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        EntityPlayer entityPlayer = event.getPlayer();
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (entityPlayer == null || itemStack == null) {
            return;
        }
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return;
        }
        if (event.block instanceof BlockCoverable && entityPlayer.field_71075_bZ.field_75098_d && (item instanceof ICarpentersHammer || item instanceof ICarpentersChisel)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        if (event.isCanceled() || event == IGNORE_INTERACT_EVENT) {
            return;
        }
        Block block = event.entity.field_70170_p.func_147439_a(event.x, event.y, event.z);
        if (block instanceof BlockCoverable) {
            eventFace = event.face;
            EntityPlayer eventEntityPlayer = event.entityPlayer;
            ItemStack itemStack = eventEntityPlayer.func_70694_bm();
            MovingObjectPosition object = this.getMovingObjectPositionFromPlayer(eventEntityPlayer.field_70170_p, eventEntityPlayer);
            if (object != null) {
                hitX = (float)object.field_72307_f.field_72450_a - (float)event.x;
                hitY = (float)object.field_72307_f.field_72448_b - (float)event.y;
                hitZ = (float)object.field_72307_f.field_72449_c - (float)event.z;
            } else {
                hitZ = 1.0f;
                hitY = 1.0f;
                hitX = 1.0f;
            }
            switch (event.action) {
                case LEFT_CLICK_BLOCK: {
                    boolean toolEquipped;
                    boolean bl = toolEquipped = itemStack != null && (itemStack.func_77973_b() instanceof ICarpentersHammer || itemStack.func_77973_b() instanceof ICarpentersChisel);
                    if (event.entity.field_70170_p.field_72995_K || !toolEquipped || !eventEntityPlayer.field_71075_bZ.field_75098_d) break;
                    block.func_149699_a(eventEntityPlayer.field_70170_p, event.x, event.y, event.z, eventEntityPlayer);
                    break;
                }
                case RIGHT_CLICK_BLOCK: {
                    if (!eventEntityPlayer.func_70093_af() || itemStack != null && itemStack.func_77973_b() instanceof ItemBlock && !BlockProperties.isOverlay(itemStack)) break;
                    event.setCanceled(true);
                    if (!event.entity.field_70170_p.field_72995_K) break;
                    PacketHandler.sendPacketToServer(new PacketActivateBlock(event.x, event.y, event.z, event.face));
                    break;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        ItemStack itemStack;
        EntityClientPlayerMP entityPlayer;
        if (event.button < 0 && (entityPlayer = Minecraft.func_71410_x().field_71439_g) != null && entityPlayer.func_70093_af() && (itemStack = entityPlayer.func_70694_bm()) != null && itemStack.func_77973_b() instanceof ItemBlock && BlockProperties.toBlock(itemStack).equals(BlockRegistry.blockCarpentersSlope)) {
            if (event.dwheel != 0) {
                PacketHandler.sendPacketToServer(new PacketSlopeSelect(entityPlayer.field_71071_by.field_70461_c, event.dwheel > 0));
            }
            event.setCanceled(true);
        }
    }

    private MovingObjectPosition getMovingObjectPositionFromPlayer(World world, EntityPlayer entityPlayer) {
        double xPos = entityPlayer.field_70169_q + (entityPlayer.field_70165_t - entityPlayer.field_70169_q);
        double yPos = entityPlayer.field_70167_r + (entityPlayer.field_70163_u - entityPlayer.field_70167_r) + (double)(world.field_72995_K ? entityPlayer.func_70047_e() - entityPlayer.getDefaultEyeHeight() : entityPlayer.func_70047_e());
        double zPos = entityPlayer.field_70166_s + (entityPlayer.field_70161_v - entityPlayer.field_70166_s);
        float pitch = entityPlayer.field_70127_C + (entityPlayer.field_70125_A - entityPlayer.field_70127_C);
        float yaw = entityPlayer.field_70126_B + (entityPlayer.field_70177_z - entityPlayer.field_70126_B);
        float commonComp = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float xComp = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI)) * commonComp;
        float yComp = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float zComp = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI)) * commonComp;
        double reachDist = 5.0;
        if (entityPlayer instanceof EntityPlayerMP) {
            reachDist = ((EntityPlayerMP)entityPlayer).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec1 = Vec3.func_72443_a((double)xPos, (double)yPos, (double)zPos);
        Vec3 vec2 = vec1.func_72441_c((double)xComp * reachDist, (double)yComp * reachDist, (double)zComp * reachDist);
        return world.func_72933_a(vec1, vec2);
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        World world = entity.field_70170_p;
        if (!this.isMovingOnGround((Entity)entity)) {
            return;
        }
        TEBase TE = this.getTileEntityAtFeet((Entity)entity);
        if (TE != null) {
            Block block;
            ItemStack itemStack = BlockProperties.getFeatureSensitiveSideItemStack(TE, ForgeDirection.UP);
            if (world.field_72995_K && entity.func_70051_ag() && !entity.func_70090_H()) {
                ParticleHelper.spawnTileParticleAt((Entity)entity, itemStack);
            }
            TE.func_145838_q().field_149765_K = (block = BlockProperties.toBlock(itemStack)) instanceof BlockCoverable ? Blocks.field_150346_d.field_149765_K : block.field_149765_K;
        }
    }

    private TEBase getApproximateSoundOrigin(World world, int x, int y, int z) {
        TileEntity TE = world.func_147438_o(x, y, z);
        if (TE != null && TE instanceof TEBase) {
            return (TEBase)TE;
        }
        TileEntity TE_YN = world.func_147438_o(x, y - 1, z);
        if (TE_YN != null && TE_YN instanceof TEBase) {
            return (TEBase)TE_YN;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlaySoundEvent(PlaySoundEvent17 event) {
        if (event != null && event.name != null && event.name.contains("CarpentersBlocks") && FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
            int x = MathHelper.func_76128_c((double)event.sound.func_147649_g());
            int y = MathHelper.func_76128_c((double)event.sound.func_147654_h());
            int z = MathHelper.func_76128_c((double)event.sound.func_147651_i());
            Block block = Blocks.field_150344_f;
            TEBase TE = this.getApproximateSoundOrigin((World)world, x, y, z);
            if (TE != null) {
                if (TE.hasAttribute(TEBase.ATTR_COVER[6])) {
                    block = BlockProperties.toBlock(BlockProperties.getCoverSafe(TE, 6));
                }
            }
            event.result = event.name.startsWith("step.") ? new PositionedSoundRecord(new ResourceLocation(block.field_149762_H.func_150498_e()), block.field_149762_H.func_150497_c() * 0.15f, block.field_149762_H.func_150494_d(), (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f) : new PositionedSoundRecord(new ResourceLocation(block.field_149762_H.func_150495_a()), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlaySoundAtEntityEvent(PlaySoundAtEntityEvent event) {
        if (event != null && event.name != null && event.name.contains("CarpentersBlocks")) {
            Entity entity = event.entity;
            if (!this.isMovingOnGround(entity)) {
                return;
            }
            TEBase TE = this.getTileEntityAtFeet(entity);
            if (TE != null) {
                event.name = Blocks.field_150344_f.field_149762_H.func_150498_e();
                Block block = BlockProperties.toBlock(BlockProperties.getFeatureSensitiveSideItemStack(TE, ForgeDirection.UP));
                if (!(block instanceof BlockCoverable)) {
                    event.name = block.field_149762_H.func_150498_e();
                }
            }
        }
    }

    private TEBase getTileEntityAtFeet(Entity entity) {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        TileEntity tileEntity = entity.field_70170_p.func_147438_o(x, y = MathHelper.func_76128_c((double)(entity.field_70163_u - (double)0.2f - (double)entity.field_70129_M)), z = MathHelper.func_76128_c((double)entity.field_70161_v));
        if (tileEntity != null && tileEntity instanceof TEBase) {
            return (TEBase)tileEntity;
        }
        return null;
    }

    private boolean isMovingOnGround(Entity entity) {
        return entity.field_70122_E && (entity.field_70159_w != 0.0 || entity.field_70179_y != 0.0);
    }
}

