/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.network.packets.client;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.util.ArrayList;
import mcp.mobius.opis.data.holders.basetypes.CoordinatesChunk;
import mcp.mobius.opis.events.PlayerTracker;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.enums.AccessLevel;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class PacketReqChunks
extends PacketBase {
    public int dim;
    public ArrayList<CoordinatesChunk> chunks = new ArrayList();

    public PacketReqChunks() {
    }

    public PacketReqChunks(int dim, ArrayList<CoordinatesChunk> chunks) {
        this.dim = dim;
        this.chunks = chunks;
    }

    @Override
    public void encode(ByteArrayDataOutput output) {
        output.writeInt(this.dim);
        output.writeInt(this.chunks.size());
        for (CoordinatesChunk coord : this.chunks) {
            coord.writeToStream(output);
        }
    }

    @Override
    public void decode(ByteArrayDataInput input) {
        this.dim = input.readInt();
        int nchunks = input.readInt();
        for (int i = 0; i < nchunks; ++i) {
            this.chunks.add(CoordinatesChunk.readFromStream(input));
        }
    }

    @Override
    public void actionServer(World world, EntityPlayerMP player) {
        if (PlayerTracker.INSTANCE.getPlayerAccessLevel(player).ordinal() > AccessLevel.PRIVILEGED.ordinal()) {
            ArrayList<Chunk> list = new ArrayList<Chunk>();
            if (world != null) {
                for (CoordinatesChunk chunk : this.chunks) {
                    list.add(world.func_72964_e(chunk.chunkX, chunk.chunkZ));
                }
            }
        }
    }
}

