/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads;

import com.google.common.collect.Sets;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.blay09.mods.cookingforblockheads.api.kitchen.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.kitchen.IKitchenSmeltingProvider;
import net.blay09.mods.cookingforblockheads.api.kitchen.IKitchenStorageProvider;
import net.blay09.mods.cookingforblockheads.api.kitchen.IMultiblockKitchen;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class KitchenMultiBlock {
    private static final List<Block> blockConnectors = new ArrayList<Block>();
    public static final Map<String, Class<? extends IMultiblockKitchen>> tileEntityWrappers = new HashMap<String, Class<? extends IMultiblockKitchen>>();
    public static final Map<String, Class<? extends IMultiblockKitchen>> blockWrappers = new HashMap<String, Class<? extends IMultiblockKitchen>>();
    private final Set<ChunkPosition> checkedPos = Sets.newHashSet();
    private final List<IKitchenStorageProvider> storageProviderList = new ArrayList<IKitchenStorageProvider>();
    private final List<IKitchenItemProvider> itemProviderList = new ArrayList<IKitchenItemProvider>();
    private final List<IKitchenSmeltingProvider> smeltingProviderList = new ArrayList<IKitchenSmeltingProvider>();
    private final List<IInventory> sourceInventories = new ArrayList<IInventory>();

    public KitchenMultiBlock(World world, int x, int y, int z) {
        this.findNeighbourKitchenBlocks(world, x, y, z, true);
    }

    private void findNeighbourKitchenBlocks(World world, int x, int y, int z, boolean extendedUpSearch) {
        ArrayList<ChunkPosition> dirToCheck = new ArrayList<ChunkPosition>();
        for (int i = 0; i <= 5; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            int upSearch = extendedUpSearch && dir == ForgeDirection.UP ? 2 : 1;
            for (int j = 0; j < upSearch; ++j) {
                ChunkPosition pos = new ChunkPosition(x + dir.offsetX, y + dir.offsetY + j, z + dir.offsetZ);
                dirToCheck.add(pos);
            }
        }
        for (ChunkPosition pos : dirToCheck) {
            if (!this.checkedPos.add(pos)) continue;
            TileEntity tileEntity = world.func_147438_o(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
            Block block = world.func_147439_a(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c);
            IMultiblockKitchen kitchenPart = tileEntity instanceof IMultiblockKitchen ? (IMultiblockKitchen)tileEntity : (tileEntity != null ? KitchenMultiBlock.getWrapper(tileEntity) : KitchenMultiBlock.getWrapper(block));
            if (kitchenPart != null) {
                if (kitchenPart instanceof IKitchenStorageProvider) {
                    this.storageProviderList.add((IKitchenStorageProvider)kitchenPart);
                }
                if (kitchenPart instanceof IKitchenSmeltingProvider) {
                    this.smeltingProviderList.add((IKitchenSmeltingProvider)kitchenPart);
                }
                if (kitchenPart instanceof IKitchenItemProvider) {
                    this.itemProviderList.add((IKitchenItemProvider)kitchenPart);
                }
                this.findNeighbourKitchenBlocks(world, pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, true);
                continue;
            }
            if (!blockConnectors.contains(block)) continue;
            this.findNeighbourKitchenBlocks(world, pos.field_151329_a, pos.field_151327_b, pos.field_151328_c, false);
        }
    }

    public List<IInventory> getSourceInventories(InventoryPlayer playerInventory) {
        this.sourceInventories.clear();
        this.sourceInventories.add((IInventory)playerInventory);
        for (IKitchenStorageProvider provider : this.storageProviderList) {
            this.sourceInventories.add(provider.getInventory());
        }
        return this.sourceInventories;
    }

    public ItemStack smeltItem(ItemStack itemStack, int count) {
        IKitchenSmeltingProvider provider;
        ItemStack restStack = itemStack.func_77946_l().func_77979_a(count);
        Iterator<IKitchenSmeltingProvider> iterator = this.smeltingProviderList.iterator();
        while (iterator.hasNext() && (restStack = (provider = iterator.next()).smeltItem(restStack)) != null) {
        }
        itemStack.field_77994_a = itemStack.field_77994_a - (count - (restStack != null ? restStack.field_77994_a : 0));
        if (itemStack.field_77994_a <= 0) {
            return null;
        }
        return itemStack;
    }

    public static void registerConnectorBlock(Block block) {
        blockConnectors.add(block);
    }

    public boolean hasSmeltingProvider() {
        return this.smeltingProviderList.size() > 0;
    }

    public List<IKitchenItemProvider> getItemProviders() {
        return this.itemProviderList;
    }

    public static IMultiblockKitchen getWrapper(Block block) {
        Class<? extends IMultiblockKitchen> clazz;
        GameRegistry.UniqueIdentifier identifier = GameRegistry.findUniqueIdentifierFor((Block)block);
        if (identifier != null && (clazz = blockWrappers.get(identifier.modId + ":" + identifier.name)) != null) {
            try {
                return clazz.getConstructor(Block.class).newInstance(block);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static IMultiblockKitchen getWrapper(TileEntity tileEntity) {
        Class<? extends IMultiblockKitchen> clazz = tileEntityWrappers.get(tileEntity.getClass().getName());
        if (clazz != null) {
            try {
                return clazz.getConstructor(TileEntity.class).newInstance(tileEntity);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

