/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.network;

import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import squeek.spiceoflife.compat.IByteIO;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroup;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.network.PacketBase;

public class PacketFoodGroup
extends PacketBase {
    public static int foodGroupsRecieved = 0;
    private FoodGroup foodGroup = null;
    private int totalFoodGroups = 0;

    public PacketFoodGroup() {
    }

    public PacketFoodGroup(FoodGroup foodGroup) {
        this.foodGroup = foodGroup;
    }

    public static void resetCount() {
        foodGroupsRecieved = 0;
    }

    @Override
    public void pack(IByteIO data) {
        if (this.foodGroup == null) {
            return;
        }
        data.writeInt(FoodGroupRegistry.numFoodGroups());
        this.foodGroup.pack(data);
    }

    @Override
    public void unpack(IByteIO data) {
        this.totalFoodGroups = data.readInt();
        this.foodGroup = new FoodGroup();
        this.foodGroup.unpack(data);
    }

    @Override
    public PacketBase processAndReply(Side side, EntityPlayer player) {
        if (++foodGroupsRecieved > this.totalFoodGroups) {
            throw new RuntimeException("Recieved more food groups than should exist (recieved: " + foodGroupsRecieved + ", total: " + this.totalFoodGroups + ")");
        }
        FoodGroupRegistry.addFoodGroup(this.foodGroup);
        if (foodGroupsRecieved == this.totalFoodGroups) {
            FoodGroupRegistry.setInStone();
        }
        return null;
    }
}

