/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import forestry.core.items.ItemOverlay;
import forestry.core.recipes.RecipeUtil;
import forestry.plugins.PluginCore;
import java.awt.Color;
import net.minecraft.item.ItemStack;

public enum EnumElectronTube implements ItemOverlay.IOverlayInfo
{
    COPPER(new Color(14923662)),
    TIN(new Color(15137023)),
    BRONZE(new Color(14533238)),
    IRON(new Color(0xCCCCCC)),
    GOLD(new Color(0xFFFF8B)),
    DIAMOND(new Color(9237987)),
    OBSIDIAN(new Color(8809408)),
    BLAZE(new Color(14247424), new Color(16775294)),
    RUBBER(new Color(0x444444)),
    EMERALD(new Color(52289)),
    APATITE(new Color(5741785)),
    LAPIS(new Color(1857478)),
    ENDER(new Color(0x33ADAD), new Color(2446945)),
    URANIUM(new Color(-16724927), new Color(0x33ADAD));

    public static final EnumElectronTube[] VALUES;
    private final String name = "ex-" + this.ordinal();
    private final int primaryColor;
    private final int secondaryColor;

    private EnumElectronTube(Color secondaryColor) {
        this(secondaryColor, Color.WHITE);
    }

    private EnumElectronTube(Color secondaryColor, Color primaryColor) {
        this.primaryColor = primaryColor.getRGB();
        this.secondaryColor = secondaryColor.getRGB();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPrimaryColor() {
        return this.primaryColor;
    }

    @Override
    public int getSecondaryColor() {
        return this.secondaryColor;
    }

    @Override
    public boolean isSecret() {
        return false;
    }

    public void registerTubeRecipe(ItemStack stack) {
        if (stack != null) {
            for (Object stackOreDict : RecipeUtil.getOreDictRecipeEquivalents(stack)) {
                RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), PluginCore.items.tubes.get(this, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), stackOreDict});
            }
        }
    }

    public void registerTubeRecipe(String stack) {
        RecipeManagers.fabricatorManager.addRecipe(null, Fluids.GLASS.getFluid(500), PluginCore.items.tubes.get(this, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), "dustRedstone", Character.valueOf('X'), stack});
    }

    static {
        VALUES = EnumElectronTube.values();
    }
}

