/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.network.packets.PacketCoordinates;
import forestry.core.proxy.Proxies;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketErrorUpdate
extends PacketCoordinates
implements IForestryPacketClient {
    private IErrorLogic errorLogic;

    public PacketErrorUpdate() {
    }

    public PacketErrorUpdate(TileEntity tile, IErrorLogicSource errorLogicSource) {
        super(tile);
        this.errorLogic = errorLogicSource.getErrorLogic();
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.errorLogic.writeData(data);
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        TileEntity tile = this.getTarget(Proxies.common.getRenderWorld());
        if (tile instanceof IErrorLogicSource) {
            IErrorLogicSource errorSourceTile = (IErrorLogicSource)tile;
            this.errorLogic = errorSourceTile.getErrorLogic();
            this.errorLogic.readData(data);
        }
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.ERROR_UPDATE;
    }
}

