/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.blocks;

import forestry.core.blocks.IMachinePropertiesTESR;
import forestry.core.proxy.Proxies;
import forestry.core.render.IBlockRenderer;
import forestry.core.tiles.TileForestry;
import forestry.energy.tiles.TileEngineBiogas;
import forestry.energy.tiles.TileEngineClockwork;
import forestry.energy.tiles.TileEngineElectric;
import forestry.energy.tiles.TileEnginePeat;
import forestry.energy.tiles.TileGenerator;
import forestry.plugins.PluginEnergy;

public enum BlockEngineType implements IMachinePropertiesTESR
{
    ELECTRIC(TileEngineElectric.class, "EngineTin", "/engine_tin_"),
    PEAT(TileEnginePeat.class, "EngineCopper", "/engine_copper_"),
    BIOGAS(TileEngineBiogas.class, "EngineBronze", "/engine_bronze_"),
    GENERATOR(TileGenerator.class, "Generator", "/generator_"){

        @Override
        public IBlockRenderer getRenderer() {
            return Proxies.render.getRenderDefaultMachine(this.texturePath);
        }
    }
    ,
    CLOCKWORK(TileEngineClockwork.class, "EngineClockwork", "/engine_clock_");

    public static final BlockEngineType[] VALUES;
    private final String teIdent;
    private final Class<? extends TileForestry> teClass;
    protected final String texturePath;

    private BlockEngineType(Class<? extends TileForestry> teClass, String teName, String textureName) {
        this.teIdent = "forestry." + teName;
        this.teClass = teClass;
        this.texturePath = "textures/blocks" + textureName;
    }

    @Override
    public int getMeta() {
        return this.ordinal();
    }

    @Override
    public String getTeIdent() {
        return this.teIdent;
    }

    @Override
    public Class<? extends TileForestry> getTeClass() {
        return this.teClass;
    }

    @Override
    public IBlockRenderer getRenderer() {
        return PluginEnergy.proxy.getRenderDefaultEngine(this.texturePath);
    }

    static {
        VALUES = BlockEngineType.values();
    }
}

