/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.vect.MutableVect;
import forestry.core.utils.vect.Vect;
import forestry.core.utils.vect.VectUtil;
import forestry.farming.logic.CropRubber;
import forestry.farming.logic.FarmLogic;
import forestry.plugins.compat.PluginIC2;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class FarmLogicRubber
extends FarmLogic {
    private boolean inActive;
    private final HashMap<Vect, Integer> lastExtents = new HashMap();

    public FarmLogicRubber(IFarmHousing housing) {
        super(housing);
        if (PluginIC2.rubberwood == null || PluginIC2.resin == null) {
            Log.warning("Failed to init a farm logic %s since IC2 was not found", (Object)this.getClass().getName());
            this.inActive = true;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        if (!this.inActive) {
            return PluginIC2.resin.func_77954_c();
        }
        return Items.field_151016_H.func_77617_a(0);
    }

    @Override
    public String getName() {
        return "Rubber Plantation";
    }

    @Override
    public int getFertilizerConsumption() {
        return 40;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(5.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack stack) {
        return false;
    }

    @Override
    public Collection<ItemStack> collect() {
        return null;
    }

    @Override
    public boolean cultivate(int x, int y, int z, FarmDirection direction, int extent) {
        return false;
    }

    @Override
    public Collection<ICrop> harvest(int x, int y, int z, FarmDirection direction, int extent) {
        int lastExtent;
        if (this.inActive) {
            return null;
        }
        Vect start = new Vect(x, y, z);
        if (!this.lastExtents.containsKey(start)) {
            this.lastExtents.put(start, 0);
        }
        if ((lastExtent = this.lastExtents.get(start).intValue()) > extent) {
            lastExtent = 0;
        }
        Vect position = this.translateWithOffset(x, y + 1, z, direction, lastExtent);
        Collection<ICrop> crops = this.getHarvestBlocks(position);
        this.lastExtents.put(start, ++lastExtent);
        return crops;
    }

    private Collection<ICrop> getHarvestBlocks(Vect position) {
        HashSet<Vect> seen = new HashSet<Vect>();
        ArrayDeque<ICrop> crops = new ArrayDeque<ICrop>();
        World world = this.getWorld();
        Block block = VectUtil.getBlock(world, position);
        if (!ItemStackUtil.equals(block, PluginIC2.rubberwood)) {
            return crops;
        }
        int meta = VectUtil.getBlockMeta(world, position);
        if (meta >= 2 && meta <= 5) {
            crops.push(new CropRubber(this.getWorld(), block, meta, position));
        }
        ArrayList<Vect> candidates = this.processHarvestBlock(crops, seen, position);
        ArrayList<Vect> temp = new ArrayList<Vect>();
        while (!candidates.isEmpty() && crops.size() < 100) {
            for (Vect candidate : candidates) {
                temp.addAll(this.processHarvestBlock(crops, seen, candidate));
            }
            candidates.clear();
            candidates.addAll(temp);
            temp.clear();
        }
        return crops;
    }

    private ArrayList<Vect> processHarvestBlock(Deque<ICrop> crops, Set<Vect> seen, Vect position) {
        World world = this.getWorld();
        ArrayList<Vect> candidates = new ArrayList<Vect>();
        MutableVect mutable = position.asMutable();
        for (int j = 0; j < 2; ++j) {
            Block block;
            mutable.y = position.y + j;
            if (mutable.equals(position) || seen.contains(mutable) || !ItemStackUtil.equals(block = VectUtil.getBlock(world, mutable), PluginIC2.rubberwood)) continue;
            Vect immutable = new Vect(mutable);
            int meta = VectUtil.getBlockMeta(world, immutable);
            if (meta >= 2 && meta <= 5) {
                crops.push(new CropRubber(world, block, meta, immutable));
            }
            candidates.add(immutable);
            seen.add(immutable);
        }
        return candidates;
    }
}

