/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.render.RenderButterflyItem;

public enum EnumButterflyState {
    FLYING(true),
    GLIDING(true),
    RISING(true),
    RESTING(false),
    HOVER(false);

    public static final EnumButterflyState[] VALUES;
    public final boolean doesMovement;

    private EnumButterflyState(boolean doesMovement) {
        this.doesMovement = doesMovement;
    }

    public float getWingFlap(EntityButterfly entity, long offset, float partialTicktime) {
        if (this == RESTING || this == HOVER) {
            long systemTime = System.currentTimeMillis();
            long flapping = systemTime + offset;
            float flap = (float)(flapping % 1000L) / 1000.0f;
            return RenderButterflyItem.getIrregularWingYaw(flapping, flap);
        }
        return (float)entity.field_70173_aa + partialTicktime;
    }

    static {
        VALUES = EnumButterflyState.values();
    }
}

