/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.client.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import net.minecraft.util.Util;
import org.lwjgl.opengl.Display;

@SideOnly(value=Side.CLIENT)
public class IconLoader {
    public static boolean setCustomIcon(String resourcePath) {
        InputStream inputStream = IconLoader.class.getClassLoader().getResourceAsStream(resourcePath);
        if (inputStream == null) {
            return false;
        }
        try {
            BufferedImage image = ImageIO.read(inputStream);
            Display.setIcon((ByteBuffer[])IconLoader.load(image));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static ByteBuffer[] load(BufferedImage image) {
        Util.EnumOS osType = Util.func_110647_a();
        ByteBuffer[] buffers = osType == Util.EnumOS.WINDOWS ? new ByteBuffer[]{IconLoader.loadInstance(image, 16), IconLoader.loadInstance(image, 32)} : (osType == Util.EnumOS.OSX ? new ByteBuffer[]{IconLoader.loadInstance(image, 128)} : new ByteBuffer[]{IconLoader.loadInstance(image, 32)});
        return buffers;
    }

    private static ByteBuffer loadInstance(BufferedImage image, int dimension) {
        BufferedImage scaledIcon = new BufferedImage(dimension, dimension, 3);
        Graphics2D g = scaledIcon.createGraphics();
        double ratio = IconLoader.getIconRatio(image, scaledIcon);
        double width = (double)image.getWidth() * ratio;
        double height = (double)image.getHeight() * ratio;
        g.drawImage(image, (int)(((double)scaledIcon.getWidth() - width) / 2.0), (int)(((double)scaledIcon.getHeight() - height) / 2.0), (int)width, (int)height, null);
        g.dispose();
        return IconLoader.convertToByteBuffer(scaledIcon);
    }

    private static double getIconRatio(BufferedImage src, BufferedImage icon) {
        double ratio = src.getWidth() > icon.getWidth() ? (double)icon.getWidth() / (double)src.getWidth() : (double)(icon.getWidth() / src.getWidth());
        if (src.getHeight() > icon.getHeight()) {
            double r2 = (double)icon.getHeight() / (double)src.getHeight();
            if (r2 < ratio) {
                ratio = r2;
            }
        } else {
            double r2 = icon.getHeight() / src.getHeight();
            if (r2 < ratio) {
                ratio = r2;
            }
        }
        return ratio;
    }

    public static ByteBuffer convertToByteBuffer(BufferedImage image) {
        byte[] buffer = new byte[image.getWidth() * image.getHeight() * 4];
        int counter = 0;
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                int colorSpace = image.getRGB(j, i);
                buffer[counter] = (byte)(colorSpace << 8 >> 24);
                buffer[counter + 1] = (byte)(colorSpace << 16 >> 24);
                buffer[counter + 2] = (byte)(colorSpace << 24 >> 24);
                buffer[counter + 3] = (byte)(colorSpace >> 24);
                counter += 4;
            }
        }
        return ByteBuffer.wrap(buffer);
    }
}

