/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.mantle;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

class BookDataReader {
    private static final DocumentBuilderFactory DB_FACTORY = DocumentBuilderFactory.newInstance();

    BookDataReader() {
    }

    @Nonnull
    Document readBook(String xmlDocumentLocation) {
        Document document;
        block8: {
            InputStream stream = this.loadBook(xmlDocumentLocation);
            try {
                document = this.readBookDocument(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    throw new IllegalStateException("Failed to load book data from " + xmlDocumentLocation + ":\n" + e.getMessage(), e);
                }
            }
            stream.close();
        }
        return document;
    }

    @Nonnull
    private InputStream loadBook(String path) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(path);
        if (Objects.isNull(inputStream)) {
            throw new IOException("File " + path + " does not exist.");
        }
        return inputStream;
    }

    @Nonnull
    private Document readBookDocument(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        Document doc = DB_FACTORY.newDocumentBuilder().parse(stream);
        doc.getDocumentElement().normalize();
        return doc;
    }
}

