/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.recipes;

import com.dreammaster.recipes.IngredientsFlattener;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

class ResolvedIngredientsFlattener
implements IngredientsFlattener {
    ResolvedIngredientsFlattener() {
    }

    @Override
    public ItemStack[] flatten(Object[] ingredients) {
        return (ItemStack[])Arrays.stream(ingredients).map(this::flattenIngredient).toArray(ItemStack[]::new);
    }

    private ItemStack flattenIngredient(Object ingredient) {
        if (ingredient instanceof List) {
            List list = (List)ingredient;
            if (Objects.isNull(ingredient = ResolvedIngredientsFlattener.getFirstFromList(list))) {
                throw new IllegalArgumentException("List provided in resolved ingredients contains nulls!");
            }
        } else if (Objects.isNull(ingredient)) {
            return null;
        }
        if (ingredient instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)ingredient;
            return itemStack;
        }
        throw new IllegalArgumentException(ResolvedIngredientsFlattener.describeUnexpectedIngredient(ingredient));
    }

    private static Object getFirstFromList(List<?> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Empty list provided in resolved ingredients!");
        }
        return list.get(0);
    }

    @Nonnull
    private static String describeUnexpectedIngredient(Object itemStackCandidate) {
        return "Unexpected recipe ingredient! " + itemStackCandidate + " : " + itemStackCandidate.getClass().getName();
    }
}

