/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.botanichorizons.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import net.fuzzycraft.botanichorizons.util.NonFuzzyInfusionRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;

public class ResearchBuilder {
    public static final String category = "botanichorizons";
    public static final String prefix = "BH_";
    public final String key;
    public int row = 0;
    public int col = 0;
    public int researchDifficulty = 1;
    public int warp = 0;
    public boolean mainline = false;
    public String[] dependencies = new String[0];
    public String[] hiddenDependencies = new String[0];
    public AspectList researchAspects;
    public LinkedList<ResearchPage> content = new LinkedList();
    public ResourceLocation researchIcon = new ResourceLocation("botania", "textures/items/grassSeeds0.png");
    public ItemStack researchItemIcon = null;

    public ResearchBuilder(String key) {
        this.key = prefix + key;
    }

    public ResearchBuilder setResearchAspects(Aspect ... aspects) {
        AspectList list = new AspectList();
        for (Aspect aspect : aspects) {
            list.add(aspect, 1);
        }
        this.researchAspects = list;
        return this;
    }

    public ResearchBuilder setBookLocation(int x, int y) {
        this.row = y;
        this.col = x;
        return this;
    }

    public ResearchBuilder setDifficulty(int difficulty) {
        this.researchDifficulty = difficulty;
        return this;
    }

    public ResearchBuilder setResearchIconItem(String mod, String filename) {
        this.researchIcon = new ResourceLocation(mod, "textures/items/" + filename);
        return this;
    }

    public ResearchBuilder setResearchIconBlock(String mod, String filename) {
        this.researchIcon = new ResourceLocation(mod, "textures/blocks/" + filename);
        return this;
    }

    public ResearchBuilder setResearchIconItemStack(ItemStack render) {
        this.researchItemIcon = render;
        return this;
    }

    public ResearchBuilder addSingleTextPage() {
        this.content.add(new ResearchPage(this.key, "botanichorizons." + this.key + ".body"));
        return this;
    }

    public ResearchBuilder addTextPages(int i18n_start, int count) {
        for (int i = i18n_start; i < i18n_start + count; ++i) {
            this.content.add(new ResearchPage(this.key, "botanichorizons." + this.key + ".body_" + i));
        }
        return this;
    }

    public ResearchBuilder addCraftingRecipe(ItemStack out, AspectList aspects, Object ... craftingRecipe) {
        ShapedArcaneRecipe recipe = ThaumcraftApi.addArcaneCraftingRecipe((String)this.key, (ItemStack)out, (AspectList)aspects, (Object[])craftingRecipe);
        this.content.add(new ResearchPage((IArcaneRecipe)recipe));
        return this;
    }

    public ResearchBuilder addShapelessCraftingRecipe(ItemStack out, AspectList aspects, Object ... craftingRecipe) {
        ShapelessArcaneRecipe recipe = ThaumcraftApi.addShapelessArcaneCraftingRecipe((String)this.key, (ItemStack)out, (AspectList)aspects, (Object[])craftingRecipe);
        this.content.add(new ResearchPage((IArcaneRecipe)recipe));
        return this;
    }

    public ResearchBuilder addCrucibleRecipe(AspectList aspects, ItemStack out, ItemStack in) {
        CrucibleRecipe recipe = ThaumcraftApi.addCrucibleRecipe((String)this.key, (ItemStack)out, (Object)in, (AspectList)aspects);
        this.content.add(new ResearchPage(recipe));
        return this;
    }

    public ResearchBuilder addInfusionRecipe(AspectList aspects, ItemStack out, int instability, ItemStack centerItem, ItemStack ... inputs) {
        NonFuzzyInfusionRecipe patchedRecipe = new NonFuzzyInfusionRecipe(this.key, out, instability, aspects, centerItem, inputs);
        try {
            Field reflectionTarget = ThaumcraftApi.class.getDeclaredField("craftingRecipes");
            reflectionTarget.setAccessible(true);
            ArrayList craftingArray = (ArrayList)reflectionTarget.get(ThaumcraftApi.class);
            craftingArray.add(patchedRecipe);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot apply better infusion pattern", e);
        }
        this.content.add(new ResearchPage((InfusionRecipe)patchedRecipe));
        return this;
    }

    public ResearchBuilder setWarp(int warp) {
        this.warp = warp;
        return this;
    }

    public ResearchBuilder setMainlineResearch() {
        this.mainline = true;
        return this;
    }

    public ResearchBuilder setDependencies(String ... dependencies) {
        this.dependencies = dependencies;
        for (int i = 0; i < this.dependencies.length; ++i) {
            this.dependencies[i] = prefix + this.dependencies[i];
        }
        return this;
    }

    public ResearchBuilder setExternalDependencies(String ... dependencies) {
        this.hiddenDependencies = dependencies;
        return this;
    }

    public ResearchBuilder apply(WithResearchBuilder lambda) {
        lambda.apply(this);
        return this;
    }

    public void commit() {
        ResearchItem research = this.researchItemIcon != null ? new ResearchItem(this.key, category, this.researchAspects, this.col, this.row, this.researchDifficulty, this.researchItemIcon) : new ResearchItem(this.key, category, this.researchAspects, this.col, this.row, this.researchDifficulty, this.researchIcon);
        research.setPages(this.content.toArray(new ResearchPage[0]));
        research.parents = this.dependencies;
        research.parentsHidden = this.hiddenDependencies;
        research.setConcealed();
        if (this.mainline) {
            research.setSpecial();
        }
        ResearchCategories.addResearch((ResearchItem)research);
        if (this.warp > 0) {
            ThaumcraftApi.addWarpToResearch((String)this.key, (int)this.warp);
        }
    }

    public static interface WithResearchBuilder {
        public void apply(ResearchBuilder var1);
    }
}

