/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.botanichorizons.util.multiblock;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.fuzzycraft.botanichorizons.util.multiblock.MultiblockCheck;
import net.fuzzycraft.botanichorizons.util.multiblock.MultiblockHelper;
import net.fuzzycraft.botanichorizons.util.multiblock.MultiblockStructure;

public class MultiblockBuilder {
    private final Map<String, MultiblockCheck> blockTypes = new HashMap<String, MultiblockCheck>();
    private String rootType = "x";
    private final String ignoreType = " ";

    public MultiblockBuilder setRootCharacter(String character) {
        if (character.length() != 1) {
            throw new IllegalArgumentException("root not a single character: " + character);
        }
        this.rootType = character;
        return this;
    }

    public MultiblockBuilder addCheck(String character, MultiblockCheck check) {
        if (character.length() != 1) {
            throw new IllegalArgumentException("root not a single character: " + character);
        }
        if (this.blockTypes.containsKey(character)) {
            throw new IllegalArgumentException("Block type already set: " + character);
        }
        this.blockTypes.put(character, check);
        return this;
    }

    public MultiblockHelper buildForMap(String[] ... layers) {
        if (layers.length == 0) {
            throw new IllegalArgumentException("No layers specified");
        }
        boolean rootFound = false;
        int rootX = 0;
        int rootY = 0;
        int rootZ = 0;
        for (int y = 0; y < layers.length; ++y) {
            for (int z = 0; z < layers[y].length; ++z) {
                int pos = layers[y][z].indexOf(this.rootType);
                if (pos < 0) continue;
                if (rootFound) {
                    throw new IllegalArgumentException("Double root at (" + rootX + ", " + rootY + ", " + rootZ + ") and (" + pos + ", " + y + ", " + z + ")");
                }
                rootFound = true;
                rootX = pos;
                rootY = y;
                rootZ = z;
            }
        }
        LinkedList<MultiblockStructure> parts = new LinkedList<MultiblockStructure>();
        for (int y = 0; y < layers.length; ++y) {
            for (int z = 0; z < layers[y].length; ++z) {
                for (int x = 0; x < layers[y][z].length(); ++x) {
                    String character = "" + layers[y][z].charAt(x);
                    if (character.equals(this.rootType) || character.equals(" ")) continue;
                    MultiblockCheck check = this.blockTypes.get(character);
                    if (check == null) {
                        throw new IllegalArgumentException("Unknown character in definition: " + character);
                    }
                    parts.add(new MultiblockStructure(x - rootX, y - rootY, z - rootZ, check));
                }
            }
        }
        return new MultiblockHelper(parts.toArray(new MultiblockStructure[0]));
    }
}

