/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import gcewing.projectblue.Matrix3;
import gcewing.projectblue.Vector3;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class Trans3 {
    public static Trans3 ident = new Trans3(Vector3.zero, Matrix3.ident, 1.0);
    public Vector3 offset;
    public Matrix3 rotation;
    public double scaling;

    Trans3(Vector3 v, Matrix3 m, double s) {
        this.offset = v;
        this.rotation = m;
        this.scaling = s;
    }

    Trans3(double dx, double dy, double dz) {
        this(new Vector3(dx, dy, dz), Matrix3.ident, 1.0);
    }

    public Trans3 translate(double dx, double dy, double dz) {
        return new Trans3(this.offset.add(this.rotation.mul(dx * this.scaling, dy * this.scaling, dz * this.scaling)), this.rotation, this.scaling);
    }

    public Trans3 rotate(Matrix3 m) {
        return new Trans3(this.offset, this.rotation.mul(m), this.scaling);
    }

    public Trans3 scale(double s) {
        return new Trans3(this.offset, this.rotation, this.scaling * s);
    }

    public Trans3 side(int i) {
        return this.rotate(Matrix3.sideRotations[i]);
    }

    public Trans3 turn(int i) {
        return this.rotate(Matrix3.turnRotations[i]);
    }

    public Trans3 t(Trans3 t) {
        return new Trans3(this.offset.add(this.rotation.mul(t.offset).mul(this.scaling)), this.rotation.mul(t.rotation), this.scaling * t.scaling);
    }

    public Vector3 p(double x, double y, double z) {
        return this.p(new Vector3(x, y, z));
    }

    public Vector3 p(Vector3 u) {
        return this.offset.add(this.rotation.mul(u.mul(this.scaling)));
    }

    public Vector3 ip(double x, double y, double z) {
        return this.ip(new Vector3(x, y, z));
    }

    public Vector3 ip(Vector3 u) {
        return this.rotation.imul(u.sub(this.offset)).mul(1.0 / this.scaling);
    }

    public Vector3 v(double x, double y, double z) {
        return this.v(new Vector3(x, y, z));
    }

    public Vector3 iv(double x, double y, double z) {
        return this.iv(new Vector3(x, y, z));
    }

    public Vector3 v(Vector3 u) {
        return this.rotation.mul(u.mul(this.scaling));
    }

    public Vector3 iv(Vector3 u) {
        return this.rotation.imul(u).mul(1.0 / this.scaling);
    }

    public AxisAlignedBB t(AxisAlignedBB box) {
        return Trans3.boxEnclosing(this.p(box.field_72340_a, box.field_72338_b, box.field_72339_c), this.p(box.field_72336_d, box.field_72337_e, box.field_72334_f));
    }

    public AxisAlignedBB box(Vector3 p0, Vector3 p1) {
        return Trans3.boxEnclosing(this.p(p0), this.p(p1));
    }

    public static int turnFor(Entity e, int side) {
        if (side > 1) {
            return 0;
        }
        int rot = Math.round(e.field_70177_z / 90.0f);
        rot = side == 0 ? 2 - rot : 2 + rot;
        return rot & 3;
    }

    static AxisAlignedBB boxEnclosing(Vector3 p, Vector3 q) {
        return AxisAlignedBB.func_72330_a((double)Math.min(p.x, q.x), (double)Math.min(p.y, q.y), (double)Math.min(p.z, q.z), (double)Math.max(p.x, q.x), (double)Math.max(p.y, q.y), (double)Math.max(p.z, q.z));
    }

    public static ForgeDirection forgeDirection(double dx, double dy, double dz) {
        if (dy < -0.5) {
            return ForgeDirection.DOWN;
        }
        if (dy > 0.5) {
            return ForgeDirection.UP;
        }
        if (dx < -0.5) {
            return ForgeDirection.WEST;
        }
        if (dx > 0.5) {
            return ForgeDirection.EAST;
        }
        if (dz < -0.5) {
            return ForgeDirection.NORTH;
        }
        return ForgeDirection.SOUTH;
    }

    public static ForgeDirection forgeDirection(Vector3 v) {
        return Trans3.forgeDirection(v.x, v.y, v.z);
    }

    public ForgeDirection t(ForgeDirection dir) {
        Vector3 d = this.v(dir.offsetX, dir.offsetY, dir.offsetZ);
        ForgeDirection result = Trans3.forgeDirection(d);
        return result;
    }

    public ForgeDirection it(ForgeDirection dir) {
        return Trans3.forgeDirection(this.iv(dir.offsetX, dir.offsetY, dir.offsetZ));
    }
}

